/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.format.coff.CoffMachineType;
import ghidra.app.util.bin.format.coff.CoffSymbol;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class CoffSymbolSpecial {
    public static final String DOT_FILE = ".file";
    public static final String DOT_TEXT = ".text";
    public static final String DOT_DATA = ".data";
    public static final String DOT_BSS = ".bss";
    public static final String DOT_BB = ".bb";
    public static final String DOT_EB = ".eb";
    public static final String DOT_BF = ".bf";
    public static final String DOT_EF = ".ef";
    public static final String DOT_TARGET = ".target";
    public static final String DOT_NFAKE = ".nfake";
    public static final String DOT_EOS = ".eos";
    public static final String DOT_ETEXT = "etext";
    public static final String DOT_EDATA = "edata";
    public static final String DOT_END = "end";

    public static final boolean isSpecial(CoffSymbol symbol) {
        Field[] declaredFields;
        for (Field field : declaredFields = CoffMachineType.class.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers) || !field.getName().startsWith("DOT_")) continue;
            try {
                String value = (String)field.get(null);
                if (value == null || !value.equals(symbol.getName())) continue;
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getStorageClass(CoffSymbol specialSymbol) {
        if (specialSymbol.getName().equals(DOT_FILE)) {
            return 103;
        }
        if (specialSymbol.getName().equals(DOT_BB)) {
            return 100;
        }
        if (specialSymbol.getName().equals(DOT_EB)) {
            return 100;
        }
        if (specialSymbol.getName().equals(DOT_BF)) {
            return 101;
        }
        if (specialSymbol.getName().equals(DOT_EF)) {
            return 101;
        }
        if (specialSymbol.getName().equals(DOT_EOS)) {
            return 102;
        }
        if (specialSymbol.getName().equals(DOT_TEXT)) {
            return 3;
        }
        if (specialSymbol.getName().equals(DOT_DATA)) {
            return 3;
        }
        if (specialSymbol.getName().equals(DOT_BSS)) {
            return 3;
        }
        return -1;
    }
}

