/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.widgets.label.GDHtmlLabel;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.ListChoice;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.util.ConflictUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;

public class ScrollingListChoicesPanel
extends ConflictPanel {
    private static final long serialVersionUID = 1L;
    private GridBagLayout gbl;
    private JPanel rowPanel;
    private GDHtmlLabel headerLabel;
    private ButtonGroup buttonGroup;
    private ListChoice leftListChoice;
    private ListChoice rightListChoice;
    private volatile ChangeListener listener;
    private ItemListener radioButtonListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source;
            if (ScrollingListChoicesPanel.this.listener != null && ((JRadioButton)(source = e.getSource())).isSelected()) {
                ResolveConflictChangeEvent re = new ResolveConflictChangeEvent(source, 0, ScrollingListChoicesPanel.this.getUseForAllChoice());
                ScrollingListChoicesPanel.this.listener.stateChanged(re);
            }
        }
    };

    public ScrollingListChoicesPanel() {
        this.init();
    }

    public ScrollingListChoicesPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder("Resolve Conflict"));
        this.gbl = new GridBagLayout();
        this.rowPanel = new JPanel(this.gbl);
        this.setLayout(new BorderLayout());
        this.headerLabel = new GDHtmlLabel(" ");
        this.headerLabel.setHorizontalAlignment(0);
        this.add((Component)this.headerLabel, "North");
        this.setHeader(null);
        this.buttonGroup = new ButtonGroup();
        this.leftListChoice = new ListChoice(this.buttonGroup, this.radioButtonListener);
        this.rightListChoice = new ListChoice(this.buttonGroup, this.radioButtonListener);
        this.gbl.columnWeights = new double[]{0.15, 0.3, 0.3, 0.15};
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 4, 2, 4);
        c.gridx = 0;
        c.gridy = 0;
        Component filler = Box.createHorizontalGlue();
        this.gbl.setConstraints(filler, c);
        this.rowPanel.add(filler);
        ++c.gridx;
        this.gbl.setConstraints(this.leftListChoice, c);
        this.rowPanel.add(this.leftListChoice);
        ++c.gridx;
        this.gbl.setConstraints(this.rightListChoice, c);
        this.rowPanel.add(this.rightListChoice);
        ++c.gridx;
        filler = Box.createHorizontalGlue();
        this.gbl.setConstraints(filler, c);
        this.rowPanel.add(filler);
        this.add((Component)this.rowPanel, "Center");
        this.add((Component)this.createUseForAllCheckBox(), "South");
    }

    void setTitle(String conflictType) {
        ((TitledBorder)this.getBorder()).setTitle("Resolve " + conflictType + " Conflict");
    }

    void setHeader(String text) {
        if (text != null && text.length() != 0) {
            this.headerLabel.setText(ConflictUtility.wrapAsHTML(text));
            this.add((Component)this.headerLabel, "North");
        } else {
            this.headerLabel.setText("");
            this.remove((Component)this.headerLabel);
        }
        this.validate();
        this.invalidate();
    }

    void setListChoice(ChangeListener listener, String[] choices, String[] listHeadings, List<String[]> leftData, List<String[]> rightData) {
        this.leftListChoice.setData(listHeadings, leftData);
        this.rightListChoice.setData(listHeadings, rightData);
        this.listener = listener;
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }

    void setChoiceNames(String leftRBText, String leftRBName, String rightRBText, String rightRBName) {
        this.leftListChoice.setChoiceName(leftRBText, leftRBName);
        this.rightListChoice.setChoiceName(rightRBText, rightRBName);
    }

    @Override
    public int getUseForAllChoice() {
        if (this.leftListChoice.rb.isSelected()) {
            return 1;
        }
        if (this.rightListChoice.rb.isSelected()) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean hasChoice() {
        return this.allChoicesAreResolved();
    }

    @Override
    public boolean allChoicesAreResolved() {
        return this.getNumConflictsResolved() == 1;
    }

    @Override
    public int getNumConflictsResolved() {
        if (this.leftListChoice.rb.isSelected() || this.rightListChoice.rb.isSelected()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean allChoicesAreSame() {
        return this.allChoicesAreResolved();
    }

    @Override
    public void removeAllListeners() {
        this.listener = null;
    }

    @Override
    public void clear() {
        this.listener = null;
        this.buttonGroup.remove(this.leftListChoice.rb);
        this.buttonGroup.remove(this.rightListChoice.rb);
        this.leftListChoice.rb.setSelected(false);
        this.rightListChoice.rb.setSelected(false);
        this.buttonGroup.add(this.leftListChoice.rb);
        this.buttonGroup.add(this.rightListChoice.rb);
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }
}

