/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.app.plugin.core.debug.client.tracermi.RmiClient;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTrace;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.Lifespan;
import java.util.Set;

public class RmiTraceObject {
    private final RmiTrace trace;
    private final String path;
    private volatile Long id;

    public RmiTraceObject(RmiTrace trace, String path) {
        this.trace = trace;
        this.path = path;
    }

    RmiTraceObject(RmiTrace trace, String path, RmiClient.RequestResult result) {
        this.trace = trace;
        this.path = path;
        result.thenAccept(id -> {
            this.id = (Long)id;
        });
    }

    public RmiTraceObject(RmiTrace trace, Long id, String path) {
        this.trace = trace;
        this.id = id;
        this.path = path;
    }

    public static RmiTraceObject fromId(RmiTrace trace, long id) {
        return new RmiTraceObject(trace, id, null);
    }

    public static RmiTraceObject fromPath(RmiTrace trace, String path) {
        return new RmiTraceObject(trace, null, path);
    }

    public Lifespan insert(long snap, TraceRmi.Resolution resolution) {
        if (resolution == null) {
            resolution = TraceRmi.Resolution.CR_ADJUST;
        }
        Lifespan span = Lifespan.nowOn((long)snap);
        if (this.id != null) {
            this.trace.client.insertObject(this.trace.getId(), this.id, span, resolution);
        } else {
            this.trace.client.insertObject(this.trace.getId(), this.path, span, resolution);
        }
        return span;
    }

    public Lifespan remove(long snap, boolean tree) {
        Lifespan span = Lifespan.nowOn((long)snap);
        if (this.id != null) {
            this.trace.client.removeObject(this.trace.getId(), this.id, span, tree);
        } else {
            this.trace.client.removeObject(this.trace.getId(), this.path, span, tree);
        }
        return span;
    }

    public void setValue(String key, Object value, long snap, String resolution) {
        Lifespan span = Lifespan.nowOn((long)snap);
        this.trace.client.setValue(this.trace.getId(), this.path, span, key, value, resolution);
    }

    public void retainValues(Set<String> keys, long snap, TraceRmi.ValueKinds kinds) {
        Lifespan span = Lifespan.nowOn((long)snap);
        this.trace.client.retainValues(this.trace.getId(), this.path, span, kinds, keys);
    }

    public void activate() {
        this.trace.client.activate(this.trace.getId(), this.path);
    }

    public String getPath() {
        return this.path;
    }
}

