/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.ColSegmentList;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegmentMap;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.RowSegmentList;
import ghidra.graph.viewer.layout.GridCoordinates;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridPoint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import java.util.function.Function;

public class OrthogonalGridSizer<V, E> {
    private static final int EDGE_ROW_PADDING = 25;
    private static final int VERTEX_ROW_PADDING = 35;
    private static final int COL_PADDING = 30;
    private static final int CONDENSED_EDGE_ROW_PADDING = 15;
    private static final int CONDENSED_VERTEX_ROW_PADDING = 25;
    private static final int CONDENSED_COL_PADDING = 15;
    private int[] rowHeights;
    private int[] beforeColEdgeWidths;
    private int[] afterColEdgeWidths;
    private int[] colVertexWidths;
    private int edgeSpacing;

    public OrthogonalGridSizer(GridLocationMap<V, E> gridMap, EdgeSegmentMap<E> segmentMap, Function<V, Shape> transformer, int edgeSpacing) {
        this.edgeSpacing = edgeSpacing;
        this.rowHeights = new int[gridMap.height()];
        this.beforeColEdgeWidths = new int[gridMap.width()];
        this.afterColEdgeWidths = new int[gridMap.width()];
        this.colVertexWidths = new int[gridMap.width()];
        this.addVertexSizes(gridMap, transformer);
        this.addEdgeRowSizes(gridMap, segmentMap);
        this.addEdgeColSizes(gridMap, segmentMap);
    }

    public GridCoordinates getGridCoordinates(boolean isCondensed) {
        int[] rowStarts = new int[this.rowCount() + 1];
        int[] colStarts = new int[this.colCount() + 1];
        int vertexRowPadding = isCondensed ? 25 : 35;
        int edgeRowPadding = isCondensed ? 15 : 25;
        int colPadding = isCondensed ? 15 : 30;
        for (int row = 1; row < rowStarts.length; ++row) {
            int rowPadding = row % 2 == 0 ? edgeRowPadding : vertexRowPadding;
            rowStarts[row] = rowStarts[row - 1] + this.height(row - 1, rowPadding);
        }
        for (int col = 1; col < colStarts.length; ++col) {
            colStarts[col] = colStarts[col - 1] + this.width(col - 1, colPadding);
        }
        return new GridCoordinates(rowStarts, colStarts);
    }

    private int rowCount() {
        return this.rowHeights.length;
    }

    private int colCount() {
        return this.colVertexWidths.length;
    }

    private int height(int row, int rowPadding) {
        return this.rowHeights[row] + rowPadding;
    }

    private int width(int col, int minColPadding) {
        int leftEdgeWidth = Math.max(this.afterColEdgeWidths[col], minColPadding);
        int leftVertexWidth = this.colVertexWidths[col] / 2;
        int rightEdgeWidth = 0;
        int rightVertexWidth = 0;
        if (col < this.colVertexWidths.length - 1) {
            rightEdgeWidth = Math.max(this.beforeColEdgeWidths[col + 1], minColPadding);
            rightVertexWidth = this.colVertexWidths[col + 1] / 2;
        }
        int width = Math.max(leftEdgeWidth + rightVertexWidth, rightEdgeWidth + leftVertexWidth);
        width = Math.max(width, leftEdgeWidth + rightEdgeWidth);
        return width;
    }

    private void addEdgeColSizes(GridLocationMap<V, E> gridMap, EdgeSegmentMap<E> segmentMap) {
        for (ColSegmentList<E> colSegments : segmentMap.colSegments()) {
            int col = colSegments.getCol();
            int edgesToLeft = -colSegments.getMinOffset();
            int edgesToRight = colSegments.getMaxOffset();
            this.addColumnEdgeWidth(col, edgesToLeft * this.edgeSpacing, edgesToRight * this.edgeSpacing);
        }
    }

    private void addEdgeRowSizes(GridLocationMap<V, E> gridMap, EdgeSegmentMap<E> segmentMap) {
        for (RowSegmentList<E> rowSegments : segmentMap.rowSegments()) {
            int row = rowSegments.getRow();
            int edgeCount = rowSegments.getMaxOffset() - rowSegments.getMinOffset();
            this.addRowHeight(row, edgeCount * this.edgeSpacing);
        }
    }

    private void addVertexSizes(GridLocationMap<V, E> gridMap, Function<V, Shape> transformer) {
        Map vertexPoints = gridMap.getVertexPoints();
        for (Map.Entry entry : vertexPoints.entrySet()) {
            Object v = entry.getKey();
            GridPoint p = (GridPoint)entry.getValue();
            Shape shape = transformer.apply(v);
            Rectangle vertexBounds = shape.getBounds();
            this.addRowHeight(p.row, vertexBounds.height);
            this.addColumnVertexWidth(p.col, vertexBounds.width);
        }
    }

    private void addRowHeight(int row, int height) {
        this.rowHeights[row] = Math.max(this.rowHeights[row], height);
    }

    private void addColumnVertexWidth(int col, int width) {
        this.colVertexWidths[col] = Math.max(this.colVertexWidths[col], width);
    }

    private void addColumnEdgeWidth(int col, int beforeWidth, int afterWidth) {
        this.beforeColEdgeWidths[col] = Math.max(this.beforeColEdgeWidths[col], beforeWidth);
        this.afterColEdgeWidths[col] = Math.max(this.afterColEdgeWidths[col], afterWidth);
    }
}

