/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.AttributeNamedNodeMap;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMNamedNodeMap;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMSelectorMatcher;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public abstract class DOMElement
extends NamespacedNode
implements CSSElement,
ParentNode {
    private static final long serialVersionUID = 2L;
    final String localName;
    final MyNamedNodeMap nodeMap;
    private final AbstractDOMNode.ChildCollections child;
    ClassList classList = null;
    private TypeInfo schemaTypeInfo = null;
    private transient WeakReference<SelectorMatcher> selectorMatcherRef = null;
    private Map<Condition, CSSStyleDeclaration> overrideStyleSet = null;
    private boolean rawTextElement = false;

    DOMElement(String string, String string2) {
        super((short)1, string2);
        this.localName = string;
        this.nodeMap = new MyNamedNodeMap();
        this.child = new NDTNode.DefaultChildNodeList(this);
    }

    @Override
    AbstractDOMNode.ChildCollections getNodeList() {
        return this.child;
    }

    void setRawText() {
        this.rawTextElement = true;
    }

    boolean isRawText() {
        return this.rawTextElement || "preserve".equalsIgnoreCase(this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space"));
    }

    @Override
    public AttributeNamedNodeMap getAttributes() {
        return this.nodeMap;
    }

    @Override
    public boolean hasAttributes() {
        return !this.nodeMap.isEmpty();
    }

    @Override
    public String getAttribute(String string) {
        Attr attr = (Attr)this.nodeMap.getNamedItem(string);
        String string2 = attr == null ? "" : attr.getValue();
        return string2;
    }

    @Override
    public String getAttributeNS(String string, String string2) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItemNS(string, string2);
        String string3 = attr == null ? "" : attr.getValue();
        return string3;
    }

    @Override
    public Attr getAttributeNode(String string) {
        return (Attr)this.nodeMap.getNamedItem(string);
    }

    @Override
    public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
        return (Attr)this.nodeMap.getNamedItemNS(string, string2);
    }

    @Override
    public boolean hasAttribute(String string) {
        boolean bl = this.nodeMap.hasAttribute(string);
        if (!bl && string.indexOf(58) == -1) {
            string = string.toLowerCase(Locale.ROOT);
            bl = this.nodeMap.hasAttribute(string);
        }
        return bl;
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) throws DOMException {
        return this.nodeMap.getNamedItemNS(string, string2) != null;
    }

    @Override
    public void removeAttribute(String string) throws DOMException {
        block2: {
            try {
                this.nodeMap.removeNamedItem(string);
            }
            catch (DOMException dOMException) {
                if (dOMException.code == 8) break block2;
                throw dOMException;
            }
        }
    }

    @Override
    public void removeAttributeNS(String string, String string2) throws DOMException {
        block2: {
            try {
                this.nodeMap.removeNamedItemNS(string, string2);
            }
            catch (DOMException dOMException) {
                if (dOMException.code == 8) break block2;
                throw dOMException;
            }
        }
    }

    @Override
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return (Attr)this.nodeMap.removeItem(attr);
    }

    @Override
    public void setAttribute(String string, String string2) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItem(string);
        if (attr == null) {
            attr = this.getOwnerDocument().createAttribute(string);
            attr.setValue(string2);
            this.nodeMap.setNamedItem(attr);
        } else {
            attr.setValue(string2);
        }
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItem(string2);
        if (attr == null || !Objects.equals(string, attr.getNamespaceURI())) {
            attr = this.getOwnerDocument().createAttributeNS(string, string2);
            this.nodeMap.setNamedItemNS(attr);
        }
        attr.setValue(string3);
    }

    @Override
    public Attr setAttributeNode(Attr attr) throws DOMException {
        return (Attr)this.nodeMap.setNamedItem(attr);
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return this.setAttributeNode(attr);
    }

    @Override
    public String getId() {
        if (!this.nodeMap.isEmpty()) {
            for (Attr attr : this.nodeMap.getNodeList()) {
                if (!attr.isId()) continue;
                return attr.getValue();
            }
        }
        return "";
    }

    @Override
    @Deprecated
    public void setIdAttribute(String string, boolean bl) {
    }

    @Override
    @Deprecated
    public void setIdAttributeNS(String string, String string2, boolean bl) {
    }

    @Override
    @Deprecated
    public void setIdAttributeNode(Attr attr, boolean bl) {
    }

    boolean isIdAttribute(String string) {
        return this.getOwnerDocument().isIdAttribute(string);
    }

    @Override
    public ElementList getElementsByTagNameNS(String string, String string2) {
        return this.child.getElementsByTagNameNS(string, string2);
    }

    @Override
    public ElementList getElementsByTagName(String string) {
        return this.child.getElementsByTagName(string, this.getOwnerDocument().isHTML());
    }

    public DOMTokenList getClassList() {
        if (this.classList == null) {
            DOMAttr dOMAttr = (DOMAttr)this.nodeMap.getNamedItem("class");
            this.classList = this.getOwnerDocument().getComplianceMode() == CSSDocument.ComplianceMode.STRICT ? new ClassList() : new QuirksClassList();
            if (dOMAttr != null && dOMAttr.value.length() != 0) {
                this.classList.setValue(dOMAttr.value);
            }
        }
        return this.classList;
    }

    @Override
    public ElementList getElementsByClassName(String string) {
        return this.child.getElementsByClassName(string, this.getOwnerDocument().getComplianceMode());
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public void setClassName(String string) {
        this.setAttribute("class", string);
    }

    public DOMElement querySelector(String string) {
        return DOMElement.querySelector(string, this.getFirstChild());
    }

    @Override
    public ElementList querySelectorAll(String string) {
        return DOMElement.querySelectorAll(string, this.getFirstChild());
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getTagName() {
        String string = this.localName;
        String string2 = this.getPrefix();
        if (string2 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 1);
        stringBuilder.append(string2).append(':').append(string);
        return stringBuilder.toString();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String lookupNamespaceURI(String string) {
        String string2 = super.lookupNamespaceURI(string);
        if (string2 == null) {
            AbstractDOMNode.RawNodeList rawNodeList = this.nodeMap.getNodeList();
            if (!rawNodeList.isEmpty()) {
                for (Attr attr : rawNodeList) {
                    String string3 = attr.getLocalName();
                    String string4 = attr.getPrefix();
                    if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                    if ("xmlns".equals(string3) && string.equals(string4)) {
                        return attr.getValue();
                    }
                    if (!"xmlns".equals(string4) || !string4.equals(string3)) continue;
                    return attr.getValue();
                }
            }
            Object object = this;
            while ((object = object.getParentNode()) != null && object.getNodeType() != 1) {
            }
            if (object != null) {
                string2 = object.lookupNamespaceURI(string2);
            }
        }
        return string2;
    }

    @Override
    public String lookupPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        AbstractDOMNode.RawNodeList rawNodeList = this.nodeMap.getNodeList();
        if (!rawNodeList.isEmpty()) {
            for (Attr attr : rawNodeList) {
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !string.equals(attr.getValue())) continue;
                String string2 = attr.getLocalName();
                String string3 = attr.getPrefix();
                if ("xmlns".equals(string2)) {
                    return string3;
                }
                if (!"xmlns".equals(string3)) continue;
                return string2;
            }
        }
        Object object = this;
        while ((object = object.getParentNode()) != null && object.getNodeType() != 1) {
        }
        if (object != null) {
            return object.lookupPrefix(string);
        }
        return string == "http://www.w3.org/XML/1998/namespace" ? "xml" : null;
    }

    @Override
    void checkAppendNodeHierarchy(Node node) {
        super.checkAppendNodeHierarchy(node);
        if (node.getNodeType() == 10) {
            throw new DOMException(3, "Doctype must be added to document.");
        }
    }

    @Override
    public DOMElement getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    public DOMElement getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    public ElementList getChildren() {
        return this.child.getChildren();
    }

    @Override
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    public Iterator<DOMNode> iterator() {
        return this.child.iterator();
    }

    @Override
    public Iterator<DOMNode> descendingIterator() {
        return this.child.createDescendingIterator();
    }

    @Override
    public Iterator<DOMNode> iterator(BitSet bitSet) {
        return this.child.createIterator(bitSet);
    }

    @Override
    public Iterator<DOMElement> elementIterator() {
        return this.child.elementIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator(String string) {
        return this.child.elementIterator(string);
    }

    @Override
    public Iterator<DOMElement> elementIteratorNS(String string, String string2) {
        return this.child.elementIteratorNS(string, string2);
    }

    @Override
    public Iterator<DOMNode> iterator(int n, NodeFilter nodeFilter) {
        return this.child.createIterator(n, nodeFilter);
    }

    @Override
    public Iterator<DOMNode> typeIterator(short s) {
        return this.iterator(NodeFilter.maskTable[s - 1], null);
    }

    @Override
    public Iterator<DOMNode> iterator(NodeFilter nodeFilter) {
        return this.child.createIterator(-1, nodeFilter);
    }

    @Override
    public NodeListIterator listIterator() {
        return this.child.createListIterator();
    }

    @Override
    public String getTextContent() throws DOMException {
        String string;
        if (this.getNodeList().isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.appendTextContent(stringBuilder);
            string = stringBuilder.toString();
        }
        return string;
    }

    public String getInnerText() {
        StringBuilder stringBuilder = new StringBuilder(256);
        this.addInnerText(this, stringBuilder, false);
        return stringBuilder.toString();
    }

    private boolean addInnerText(DOMElement dOMElement, StringBuilder stringBuilder, boolean bl) throws DOMException {
        int n;
        boolean bl2;
        ComputedCSSStyle computedCSSStyle = dOMElement.getComputedStyle(null);
        String string = computedCSSStyle.getPropertyValue("display");
        String[] stringArray = string.split(" ");
        if (!dOMElement.hasPrintableNodes() || DOMElement.matchesString(stringArray, "none") || dOMElement.isNonPrintableElement()) {
            return bl;
        }
        String string2 = computedCSSStyle.getPropertyValue("text-transform");
        short s = 0;
        if ("uppercase".equalsIgnoreCase(string2)) {
            s = 2;
        } else if ("lowercase".equalsIgnoreCase(string2)) {
            s = 1;
        } else if ("capitalize".equalsIgnoreCase(string2)) {
            s = 3;
        }
        boolean bl3 = !"hidden".equalsIgnoreCase(computedCSSStyle.getPropertyValue("visibility"));
        boolean bl4 = false;
        boolean bl5 = bl2 = DOMElement.matchesString(stringArray, "block") || DOMElement.matchesString(stringArray, "list-item") || (DOMElement.matchesString(stringArray, "table") || DOMElement.matchesString(stringArray, "table-caption")) && !(bl4 = DOMElement.matchesString(stringArray, "inline"));
        if (bl3) {
            if (bl2 && (n = stringBuilder.length() - 1) != -1 && stringBuilder.charAt(n) != '\n') {
                stringBuilder.append('\n');
            }
            if (DOMElement.hasPrecedingAnonymousBox(stringArray, computedCSSStyle)) {
                stringBuilder.append(' ');
            } else if (DOMElement.matchesString(stringArray, "table-cell") && dOMElement.getPreviousElementSibling() != null) {
                stringBuilder.append('\t');
            }
        }
        n = 1;
        for (DOMNode dOMNode : dOMElement.getNodeList()) {
            switch (dOMNode.getNodeType()) {
                case 1: {
                    if (!dOMNode.getChildNodes().isEmpty()) {
                        bl = this.addInnerText((DOMElement)dOMNode, stringBuilder, bl);
                        n = 0;
                        break;
                    }
                    if (!bl3) break;
                    Object object = (DOMElement)dOMNode;
                    Object object2 = ((DOMElement)object).getComputedStyle(null);
                    String string3 = ((ComputedCSSStyle)object2).getPropertyValue("display");
                    String[] stringArray2 = string3.split(" ");
                    if (DOMElement.matchesString(stringArray2, "table-cell") && ((DOMElement)object).getPreviousElementSibling() != null) {
                        stringBuilder.append('\t');
                        break;
                    }
                    bl = this.innerTextVoidElement((DOMElement)object, bl, stringBuilder);
                    break;
                }
                case 3: {
                    if (!bl3) break;
                    Object object = dOMNode.getNodeValue();
                    Object object2 = computedCSSStyle.getPropertyValue("white-space");
                    if ("pre".equalsIgnoreCase((String)object2) || "pre-wrap".equalsIgnoreCase((String)object2) || "break-spaces".equalsIgnoreCase((String)object2)) {
                        if (s == 0) {
                            stringBuilder.append((String)object);
                        } else {
                            DOMElement.appendTransformedText((String)object, s, stringBuilder);
                        }
                        bl = true;
                    } else {
                        DOMElement.appendNormalizedWhitespace((String)object, "pre-line".equalsIgnoreCase((String)object2), bl2 && n != 0, s, stringBuilder);
                        bl = false;
                    }
                    n = 0;
                    break;
                }
                case 4: {
                    if (!bl3) break;
                    Object object = dOMNode.getNodeValue();
                    stringBuilder.append((String)object);
                    n = 0;
                    bl = true;
                }
            }
        }
        if (bl3) {
            boolean bl6 = false;
            if (bl2 || (bl6 = DOMElement.matchesString(stringArray, "table-row")) && !bl4) {
                this.trimBuffer(bl, stringBuilder);
                if (!bl6 || dOMElement.getNextElementSibling() != null) {
                    stringBuilder.append('\n');
                }
            }
        }
        return bl;
    }

    private static boolean matchesString(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    boolean isNonPrintableElement() {
        return false;
    }

    private boolean hasPrintableNodes() {
        for (DOMNode dOMNode : this.getNodeList()) {
            switch (dOMNode.getNodeType()) {
                case 1: {
                    if (!((DOMElement)dOMNode).hasPrintableNodes()) break;
                    return true;
                }
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasPrecedingAnonymousBox(String[] stringArray, ComputedCSSStyle computedCSSStyle) {
        return DOMElement.matchesString(stringArray, "list-item") && "inside".equalsIgnoreCase(computedCSSStyle.getPropertyValue("list-style-position"));
    }

    boolean innerTextVoidElement(DOMElement dOMElement, boolean bl, StringBuilder stringBuilder) {
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private static void appendTransformedText(String var0, short var1_1, StringBuilder var2_2) {
        var3_3 = false;
        var4_4 = var0.length();
        var5_5 = 0;
        while (var5_5 < var4_4) {
            block7: {
                var6_6 = var0.codePointAt(var5_5);
                if (!Character.isWhitespace(var6_6)) break block7;
                if (!var3_3) {
                    var3_3 = true;
                }
                ** GOTO lbl23
            }
            if (!var3_3) ** GOTO lbl-1000
            var3_3 = false;
            if (var1_1 == 3) {
                var6_6 = Character.toUpperCase(var6_6);
                var2_2.appendCodePoint(var6_6);
            } else lbl-1000:
            // 2 sources

            {
                if (var1_1 == 2) {
                    var6_6 = Character.toUpperCase(var6_6);
                } else if (var1_1 == 1) {
                    var6_6 = Character.toLowerCase(var6_6);
                }
lbl23:
                // 5 sources

                var2_2.appendCodePoint(var6_6);
            }
            var5_5 = var0.offsetByCodePoints(var5_5, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void appendNormalizedWhitespace(String var0, boolean var1_1, boolean var2_2, short var3_3, StringBuilder var4_4) {
        var5_5 = var2_2;
        var6_6 = var4_4.length();
        if (var6_6 != 0 && Character.isWhitespace(var7_7 = var4_4.charAt(var6_6 - 1)) && (!var1_1 || var7_7 != '\n')) {
            var5_5 = true;
        }
        var9_8 = var0.length();
        var10_9 = 0;
        while (var10_9 < var9_8) {
            block14: {
                block13: {
                    var8_10 = var0.codePointAt(var10_9);
                    if (!Character.isWhitespace(var8_10)) break block13;
                    if (!var1_1 || var8_10 != 10) {
                        if (!var5_5) {
                            var5_5 = true;
                            var4_4.append(' ');
                        }
                    } else {
                        if (var5_5) {
                            var11_11 = var4_4.length() - 1;
                            var12_12 = var4_4.charAt(var11_11);
                            if (var12_12 != '\n') {
                                var4_4.setLength(var11_11);
                            }
                        } else {
                            var5_5 = true;
                        }
                        var4_4.appendCodePoint(var8_10);
                    }
                    break block14;
                }
                if (!var5_5) ** GOTO lbl-1000
                var5_5 = false;
                if (var3_3 == 3) {
                    var8_10 = Character.toUpperCase(var8_10);
                    var4_4.appendCodePoint(var8_10);
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == 2) {
                        var8_10 = Character.toUpperCase(var8_10);
                    } else if (var3_3 == 1) {
                        var8_10 = Character.toLowerCase(var8_10);
                    }
                    var4_4.appendCodePoint(var8_10);
                }
            }
            var10_9 = var0.offsetByCodePoints(var10_9, 1);
        }
    }

    void trimBuffer(boolean bl, StringBuilder stringBuilder) {
        int n;
        if (!bl && (n = stringBuilder.length() - 1) != -1 && stringBuilder.charAt(n) == ' ') {
            stringBuilder.setLength(n);
        }
    }

    @Override
    public SelectorMatcher getSelectorMatcher() {
        SelectorMatcher selectorMatcher = null;
        if (this.selectorMatcherRef != null) {
            selectorMatcher = (SelectorMatcher)this.selectorMatcherRef.get();
        }
        if (selectorMatcher == null) {
            selectorMatcher = new DOMSelectorMatcher(this);
            this.selectorMatcherRef = new WeakReference<SelectorMatcher>(selectorMatcher);
        }
        return selectorMatcher;
    }

    @Override
    public boolean matches(String string, String string2) throws DOMException {
        Condition condition;
        SelectorList selectorList;
        CSSParser cSSParser = new CSSParser();
        try {
            selectorList = cSSParser.parseSelectors(new StringReader(string));
        }
        catch (Exception exception) {
            throw new DOMException(12, "Unable to parse selector in: " + string);
        }
        if (string2 != null) {
            try {
                condition = cSSParser.parsePseudoElement(string2);
            }
            catch (Exception exception) {
                throw new DOMException(12, "Unable to parse pseudo-element in: " + string2);
            }
        } else {
            condition = null;
        }
        return this.matches(selectorList, condition);
    }

    @Override
    public boolean matches(SelectorList selectorList, Condition condition) {
        SelectorMatcher selectorMatcher = this.getSelectorMatcher();
        selectorMatcher.setPseudoElement(condition);
        return selectorMatcher.matches(selectorList) != -1;
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        DOMDocument.StyleAttr styleAttr = (DOMDocument.StyleAttr)this.getAttributeNode("style");
        if (styleAttr == null) {
            if (this.getOwnerDocument().getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS) {
                for (Attr attr : this.getAttributes()) {
                    if (!"style".equalsIgnoreCase(attr.getNodeName())) continue;
                    return ((DOMDocument.StyleAttr)attr).getStyle();
                }
            }
            return null;
        }
        return styleAttr.getStyle();
    }

    @Override
    public boolean hasOverrideStyle(Condition condition) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(condition);
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Condition condition) {
        CSSStyleDeclaration cSSStyleDeclaration = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<Condition, CSSStyleDeclaration>(1);
        } else {
            cSSStyleDeclaration = this.overrideStyleSet.get(condition);
        }
        if (cSSStyleDeclaration == null) {
            cSSStyleDeclaration = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
            this.overrideStyleSet.put(condition, cSSStyleDeclaration);
        }
        return cSSStyleDeclaration;
    }

    @Override
    public boolean hasPresentationalHints() {
        return false;
    }

    @Override
    public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
    }

    @Override
    public ComputedCSSStyle getComputedStyle(String string) {
        Condition condition;
        if (string != null) {
            CSSParser cSSParser = new CSSParser();
            condition = cSSParser.parsePseudoElement(string);
        } else {
            condition = null;
        }
        return (ComputedCSSStyle)this.getOwnerDocument().getStyleSheet().getComputedStyle(this, condition);
    }

    @Override
    public abstract DOMElement cloneNode(boolean var1);

    abstract boolean isNonHTMLOrVoid();

    abstract CSSStyleSheetFactory getStyleSheetFactory();

    public String getStartTag() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('<').append(this.getTagName());
        if (this.nodeMap.getLength() > 0) {
            stringBuilder.append(' ');
            this.nodeMap.appendTo(stringBuilder);
        }
        if (this.hasChildNodes()) {
            stringBuilder.append('>');
        } else {
            stringBuilder.append(" />");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        int n = 32;
        if (this.hasChildNodes()) {
            n = 720;
        } else if (this.hasAttributes()) {
            n = 128;
        }
        String string = this.getTagName();
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append('<').append(string);
        if (this.nodeMap.getLength() > 0) {
            stringBuilder.append(' ');
            this.nodeMap.appendTo(stringBuilder);
        }
        if (this.hasChildNodes() || !this.isNonHTMLOrVoid()) {
            stringBuilder.append('>');
            if (this.hasChildNodes()) {
                DOMNodeList dOMNodeList = this.getChildNodes();
                for (int i = 0; i < dOMNodeList.getLength(); ++i) {
                    stringBuilder.append(dOMNodeList.item(i).toString());
                }
            }
            stringBuilder.append("</").append(string).append('>');
        } else {
            if (this.getNamespaceURI() == "http://www.w3.org/1999/xhtml") {
                stringBuilder.append(' ');
            }
            stringBuilder.append("/>");
        }
        return stringBuilder.toString();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new ElementTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    class ClassList
    extends DOMTokenSetImpl {
        private static final long serialVersionUID = 1L;

        ClassList() {
        }

        @Override
        public void setValue(String string) throws DOMException {
            if (string == null || string.length() == 0) {
                this.clear();
                string = "";
            }
            super.setValue(string);
        }

        @Override
        protected void addUnchecked(String string) throws DOMException {
            super.addUnchecked(string);
            if (!DOMElement.this.nodeMap.hasAttribute("class")) {
                DOMAttr dOMAttr = (DOMAttr)DOMElement.this.getOwnerDocument().createAttributeNS(null, "class");
                dOMAttr.setValue(string);
                DOMElement.this.nodeMap.setNamedItem(dOMAttr);
                dOMAttr.setAttributeOwner(DOMElement.this);
            }
        }
    }

    static class ElementTypeInfo
    extends DOMTypeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ElementTypeInfo() {
        }

        @Override
        public String getTypeNamespace() {
            return null;
        }
    }

    class MyNamedNodeMap
    extends DOMNamedNodeMap<DOMAttr>
    implements AttributeNamedNodeMap {
        private static final long serialVersionUID = 1L;

        MyNamedNodeMap() {
            super((short)2);
        }

        @Override
        public Iterator<Attr> iterator() {
            return this.getNodeList().attributeIterator();
        }

        @Override
        void registerNode(DOMAttr dOMAttr) {
            dOMAttr.setAttributeOwner(DOMElement.this);
        }

        @Override
        void unregisterNode(DOMAttr dOMAttr) {
            dOMAttr.setAttributeOwner(null);
        }

        @Override
        void verifyNewNode(Node node) throws DOMException {
            super.verifyNewNode(node);
            Element element = ((Attr)node).getOwnerElement();
            if (element != null && element != DOMElement.this) {
                throw new DOMException(10, "Attribute is already in use.");
            }
        }

        @Override
        DOMElement getOwnerNode() {
            return DOMElement.this;
        }
    }

    class QuirksClassList
    extends ClassList {
        private static final long serialVersionUID = 1L;

        QuirksClassList() {
        }

        @Override
        public void setValue(String string) throws DOMException {
            if (string != null) {
                string = string.toLowerCase(Locale.ROOT);
            }
            super.setValue(string);
        }

        @Override
        public boolean contains(String string) {
            if (string == null) {
                return false;
            }
            string = string.toLowerCase(Locale.ROOT);
            return super.contains(string);
        }

        @Override
        public void add(String string) throws DOMException {
            this.argumentCheckVoidSpaces(string);
            string = string.toLowerCase(Locale.ROOT);
            this.addUnchecked(string);
        }

        @Override
        public void remove(String string) throws DOMException {
            this.argumentCheckVoidSpaces(string);
            string = string.toLowerCase(Locale.ROOT);
            this.removeUnchecked(string);
        }

        @Override
        public boolean toggle(String string) throws DOMException {
            this.argumentCheckVoidSpaces(string);
            string = string.toLowerCase(Locale.ROOT);
            return this.toggleUnchecked(string);
        }

        @Override
        public void replace(String string, String string2) throws DOMException {
            this.argumentCheckVoidSpaces(string);
            this.argumentCheckVoidSpaces(string2);
            string = string.toLowerCase(Locale.ROOT);
            string2 = string2.toLowerCase(Locale.ROOT);
            this.replaceUnchecked(string, string2);
        }
    }
}

