/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.spi.ErrorConstants;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageTagRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.RegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbstractRegistryEntry
implements RegistryEntry,
ErrorConstants {
    private String name;
    private float priority;
    private List<String> exts;
    private List<String> mimeTypes;

    public AbstractRegistryEntry(String string, float f, String[] stringArray, String[] stringArray2) {
        this.name = string;
        this.priority = f;
        this.exts = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            this.exts.add(string2);
        }
        this.exts = Collections.unmodifiableList(this.exts);
        this.mimeTypes = new ArrayList<String>(stringArray2.length);
        for (String string2 : stringArray2) {
            this.mimeTypes.add(string2);
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
    }

    public AbstractRegistryEntry(String string, float f, String string2, String string3) {
        this.name = string;
        this.priority = f;
        this.exts = new ArrayList<String>(1);
        this.exts.add(string2);
        this.exts = Collections.unmodifiableList(this.exts);
        this.mimeTypes = new ArrayList<String>(1);
        this.mimeTypes.add(string3);
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
    }

    @Override
    public String getFormatName() {
        return this.name;
    }

    @Override
    public List<String> getStandardExtensions() {
        return this.exts;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    protected Filter getFormatBrokenLinkImage(ParsedURL parsedURL) {
        Object[] objectArray;
        String string;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{this.getFormatName(), parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{this.getFormatName()};
        }
        return ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
    }

    protected Filter getFormatMsgBrokenLinkImage(ParsedURL parsedURL, Throwable throwable) {
        Object[] objectArray;
        String string;
        String string2 = throwable.getClass().getSimpleName();
        if (parsedURL != null) {
            string = "url.format.unreadable.msg";
            objectArray = new Object[]{this.getFormatName(), parsedURL, string2};
        } else {
            string = "stream.format.unreadable.msg";
            objectArray = new Object[]{this.getFormatName(), string2};
        }
        return ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
    }
}

