/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.openmaps.mapelements;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.freeplane.plugin.openmaps.LocationChoosenListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class OpenMapsController
extends DefaultMapController
implements MouseListener {
    private Set<LocationChoosenListener> Listeners;
    private MapMarker currentLocation;

    public OpenMapsController(JMapViewer map) {
        super(map);
        this.configureButtons();
        this.Listeners = new LinkedHashSet<LocationChoosenListener>();
        this.currentLocation = null;
    }

    private void configureButtons() {
        this.setDoubleClickZoomEnabled(false);
        this.setMovementMouseButton(1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            ICoordinate locationChoosen = this.getSelectedLocation(e.getPoint());
            this.setMarkerAtLocation(locationChoosen);
            this.sendLocation(locationChoosen, this.getCurrentZoomLevel());
        }
    }

    public void addLocationChoosenListener(LocationChoosenListener listener) {
        this.Listeners.add(listener);
    }

    public void removeLocationChoosenListener(LocationChoosenListener listener) {
        this.Listeners.remove(listener);
    }

    private void sendLocation(ICoordinate locationChoosen, int zoom) {
        for (LocationChoosenListener l : this.Listeners) {
            l.locationChoosenAction(locationChoosen, zoom);
        }
    }

    public ICoordinate getSelectedLocation(Point clickedLocation) {
        return this.map.getPosition(clickedLocation);
    }

    public int getCurrentZoomLevel() {
        return this.map.getZoom();
    }

    private void setMarkerAtLocation(ICoordinate locationChoosen) {
        if (this.currentLocation != null) {
            this.map.removeMapMarker(this.currentLocation);
        }
        this.currentLocation = new MapMarkerDot(locationChoosen.getLat(), locationChoosen.getLon());
        this.map.addMapMarker(this.currentLocation);
    }

    public void zoomToLocation(Coordinate location, int zoom) {
        this.setMarkerAtLocation((ICoordinate)location);
        OsmMercator osmMercator = new OsmMercator();
        int x = (int)osmMercator.lonToX(location.getLon(), zoom);
        int y = (int)osmMercator.latToY(location.getLat(), zoom);
        this.map.setDisplayPosition(new Point(this.map.getWidth() / 2, this.map.getHeight() / 2), x, y, zoom);
    }
}

