/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.mindmapmode.EditNodeBase;

public class EditNodeDialog
extends EditNodeBase {
    private final JTextComponent textComponent;
    private final boolean enableSplit;
    private final AWTEvent firstEvent;
    private String title;

    public EditNodeDialog(NodeModel node, AWTEvent firstEvent, boolean editorBlocks, EditNodeBase.IEditControl editControl, boolean enableSplit, JEditorPane textEditor) {
        super(node, textEditor.getText(), editorBlocks, editControl);
        this.firstEvent = firstEvent;
        this.enableSplit = enableSplit;
        this.textComponent = textEditor;
    }

    @Override
    public void show(Window window) {
        if (this.title == null) {
            this.title = TextUtils.getText((String)"edit_long_node");
        }
        final LongNodeDialog editor = new LongNodeDialog(window, this.title, this.getBackground());
        this.redispatchKeyEvents(this.textComponent, this.firstEvent);
        if (this.firstEvent == null) {
            this.textComponent.setCaretPosition(this.textComponent.getDocument().getLength());
        }
        final JDialog dialog = editor.getDialog();
        this.getEditControl().getEditType().installHolder(this.node, dialog);
        this.configureDialog(dialog);
        this.restoreDialogSize(dialog);
        dialog.pack();
        Controller.getCurrentModeController().getController().getMapViewManager().scrollNodeToVisible(this.node);
        if (ResourceController.getResourceController().getBooleanProperty("el__position_window_below_node")) {
            UITools.setDialogLocationUnder((JDialog)dialog, (NodeModel)this.getNode());
        } else {
            UITools.setDialogLocationRelativeTo((JDialog)dialog, (NodeModel)this.getNode());
        }
        editor.show();
        dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                EditNodeDialog.this.saveDialogSize(dialog);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                editor.dispose();
            }
        });
    }

    protected void configureDialog(JDialog dialog) {
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private class LongNodeDialog
    extends EditNodeBase.EditDialog {
        public LongNodeDialog(Window window, String title, Color background) {
            super(EditNodeDialog.this, title, window);
            this.getDialog().setModal(ResourceController.getResourceController().getBooleanProperty("enforceModalEditorDialogs"));
            EditNodeDialog.this.textComponent.setText(EditNodeDialog.this.getText());
            JScrollPane ancestorScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, EditNodeDialog.this.textComponent);
            JScrollPane editorScrollPane = ancestorScrollPane != null ? ancestorScrollPane : new JScrollPane(EditNodeDialog.this.textComponent);
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            JButton splitButton = new JButton();
            final JCheckBox enterConfirms = new JCheckBox("", ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)okButton, (String)TextUtils.getRawText((String)"ok"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)cancelButton, (String)TextUtils.getRawText((String)"cancel"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)splitButton, (String)TextUtils.getRawText((String)"split"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)enterConfirms, (String)TextUtils.getRawText((String)"enter_confirms"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.submit();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.cancel();
                }
            });
            splitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.split();
                }
            });
            enterConfirms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditNodeDialog.this.textComponent.requestFocus();
                    ResourceController.getResourceController().setProperty("el__enter_confirms_by_default", Boolean.toString(enterConfirms.isSelected()));
                }
            });
            EditNodeDialog.this.textComponent.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            e.consume();
                            LongNodeDialog.this.confirmedCancel();
                            break;
                        }
                        case 10: {
                            e.consume();
                            if ((e.getModifiers() & 1) != 0 || enterConfirms.isSelected() == ((e.getModifiers() & 8) != 0)) {
                                this.insertString("\n");
                                break;
                            }
                            LongNodeDialog.this.submit();
                            break;
                        }
                        case 9: {
                            e.consume();
                            this.insertString("    ");
                        }
                    }
                }

                public void insertString(String text) {
                    try {
                        EditNodeDialog.this.textComponent.getDocument().insertString(EditNodeDialog.this.textComponent.getCaretPosition(), text, null);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            EditNodeDialog.this.textComponent.addMouseListener(new MouseListener(){

                private void conditionallyShowPopup(MouseEvent e) {
                    if (Compat.isPopupTrigger((MouseEvent)e)) {
                        JPopupMenu popupMenu = EditNodeDialog.this.createPopupMenu(EditNodeDialog.this.textComponent);
                        popupMenu.show(EditNodeDialog.this.textComponent, e.getX(), e.getY());
                        e.consume();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.conditionallyShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.conditionallyShowPopup(e);
                }
            });
            JPanel buttonPane = new JPanel();
            buttonPane.add(enterConfirms);
            buttonPane.add(okButton);
            buttonPane.add(cancelButton);
            if (EditNodeDialog.this.enableSplit) {
                buttonPane.add(splitButton);
            }
            buttonPane.setMaximumSize(new Dimension(1000, 20));
            Container contentPane = this.getDialog().getContentPane();
            contentPane.add((Component)editorScrollPane, "Center");
            boolean areButtonsAtTheTop = ResourceController.getResourceController().getBooleanProperty("el__buttons_above");
            contentPane.add((Component)buttonPane, areButtonsAtTheTop ? "North" : "South");
            EditNodeDialog.this.textComponent.requestFocus();
        }

        @Override
        protected void cancel() {
            super.cancel();
            EditNodeDialog.this.getEditControl().cancel();
        }

        @Override
        public Component getMostRecentFocusOwner() {
            if (this.getDialog().isFocused()) {
                return this.getFocusOwner();
            }
            return EditNodeDialog.this.textComponent;
        }

        @Override
        protected boolean isChanged() {
            return !EditNodeDialog.this.getText().equals(EditNodeDialog.this.textComponent.getText());
        }

        @Override
        protected void split() {
            super.split();
            EditNodeDialog.this.getEditControl().split(EditNodeDialog.this.textComponent.getText(), EditNodeDialog.this.textComponent.getCaretPosition());
        }

        @Override
        protected void submit() {
            super.submit();
            EditNodeDialog.this.getEditControl().ok(EditNodeDialog.this.textComponent.getText());
        }
    }
}

