/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.text.mindmapmode.SourceTextEditorUIConfigurator;

public class ScriptComboBoxEditor
implements ComboBoxEditor {
    private final JButton showEditorBtn = new JButton();
    private final List<ActionListener> actionListeners;
    private String script = "";
    private Dimension minimumSize;
    private Rectangle bounds;

    public ScriptComboBoxEditor() {
        this.setButtonText();
        this.showEditorBtn.setHorizontalAlignment(2);
        this.showEditorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptComboBoxEditor.this.editScript(false);
            }
        });
        this.actionListeners = new LinkedList<ActionListener>();
        this.minimumSize = new Dimension(600, 400);
        this.bounds = null;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.minimumSize = minimumSize;
    }

    protected void editScript(boolean selectAll) {
        JEditorPane textEditor = new JEditorPane();
        SourceTextEditorUIConfigurator.configureColors((JTextComponent)textEditor);
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane((Component)textEditor);
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        scrollPane.setMinimumSize(this.minimumSize);
        textEditor.setContentType("text/groovy");
        String fontName = ResourceController.getResourceController().getProperty("groovy_editor_font");
        int fontSize = ResourceController.getResourceController().getIntProperty("groovy_editor_font_size");
        Font font = UITools.scaleUI((Font)new Font(fontName, 0, fontSize));
        textEditor.setFont(font);
        textEditor.setText(this.script);
        if (selectAll) {
            textEditor.selectAll();
        }
        String title = TextUtils.getText((String)"plugins/ScriptEditor/window.title");
        JOptionPane optionPane = new JOptionPane(scrollPane, 3, 2);
        JDialog dialog = optionPane.createDialog(this.showEditorBtn, title);
        dialog.setResizable(true);
        if (this.bounds != null) {
            dialog.setBounds(this.bounds);
        } else {
            dialog.pack();
            UITools.setDialogLocationRelativeTo((JDialog)dialog, (Component)this.showEditorBtn);
            this.bounds = dialog.getBounds();
        }
        dialog.setVisible(true);
        Integer result = (Integer)optionPane.getValue();
        if (result == null || result != 0) {
            return;
        }
        this.script = textEditor.getText();
        this.setButtonText();
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(actionEvent);
        }
    }

    protected void setButtonText() {
        String text = this.script.substring(0, Math.min(40, this.script.length())).trim().replaceAll("\\s+", " ");
        if (!text.equals("")) {
            this.showEditorBtn.setToolTipText(HtmlUtils.plainToHTML((String)this.script));
            this.showEditorBtn.setText(text);
        } else {
            String title = TextUtils.getText((String)"EditScript");
            this.showEditorBtn.setToolTipText(null);
            this.showEditorBtn.setText(title);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this.showEditorBtn;
    }

    @Override
    public void setItem(Object anObject) {
        this.script = anObject == null ? "" : (String)anObject;
        this.setButtonText();
    }

    @Override
    public Object getItem() {
        return this.script;
    }

    @Override
    public void selectAll() {
        this.editScript(true);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.showEditorBtn.setPreferredSize(preferredSize);
    }

    public Dimension getPreferredSize() {
        return this.showEditorBtn.getPreferredSize();
    }
}

