/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelHoverPolicy;

public class TabbedHoverUtil {
    public static boolean isDeepestHoverableTabbedPanel(ArrayList enterables, TabbedPanel tp) {
        Component c = (Component)enterables.get(0);
        while (c != null) {
            TabbedPanel tp2 = null;
            if (c instanceof TabbedPanel) {
                tp2 = (TabbedPanel)c;
            }
            if (c instanceof TabbedPanelContentPanel) {
                tp2 = ((TabbedPanelContentPanel)c).getTabbedPanel();
            }
            if (tp2 != null) {
                if (tp2 == tp) {
                    return true;
                }
                if (tp2.getProperties().getHoverPolicy() != TabbedPanelHoverPolicy.ALWAYS_AND_EXCLUDE) {
                    return false;
                }
            }
            c = c.getParent();
        }
        return true;
    }

    public static boolean hasVisibleTabbedPanelChild(Component c) {
        if (c instanceof TabbedPanel && ((TabbedPanel)c).getProperties().getHoverPolicy() != TabbedPanelHoverPolicy.ALWAYS_AND_EXCLUDE) {
            return true;
        }
        if (c instanceof Container) {
            Container container = (Container)c;
            int i = 0;
            while (i < container.getComponentCount()) {
                if (container.getComponent(i).isVisible() && TabbedHoverUtil.hasVisibleTabbedPanelChild(container.getComponent(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean acceptTabbedPanelHover(TabbedPanelHoverPolicy policy, ArrayList enterables, TabbedPanel tp, Component c) {
        if (policy == TabbedPanelHoverPolicy.NO_HOVERED_CHILD) {
            return TabbedHoverUtil.isDeepestHoverableTabbedPanel(enterables, tp);
        }
        if (policy == TabbedPanelHoverPolicy.NEVER) {
            return false;
        }
        if (policy == TabbedPanelHoverPolicy.ALWAYS || policy == TabbedPanelHoverPolicy.ALWAYS_AND_EXCLUDE) {
            return true;
        }
        if (policy == TabbedPanelHoverPolicy.ONLY_WHEN_DEEPEST && c != null) {
            return !TabbedHoverUtil.hasVisibleTabbedPanelChild(c);
        }
        return false;
    }
}

