/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.menu;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import net.infonode.gui.icon.IconUtil;

public class MenuUtil {
    private MenuUtil() {
    }

    public static void optimizeSeparators(JPopupMenu menu) {
        boolean lastSeparator = true;
        int i = 0;
        while (i < menu.getComponentCount()) {
            if (menu.getComponent(i).isVisible() && menu.getComponent(i) instanceof JMenu) {
                MenuUtil.optimizeSeparators(((JMenu)menu.getComponent(i)).getPopupMenu());
            }
            boolean separator = menu.getComponent(i) instanceof JPopupMenu.Separator;
            if (lastSeparator && separator) {
                menu.remove(i);
            } else {
                ++i;
            }
            lastSeparator = separator;
        }
        if (menu.getComponentCount() > 0 && menu.getComponent(menu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            menu.remove(menu.getComponentCount() - 1);
        }
    }

    public static void align(MenuElement menu) {
        Object[] children = menu.getSubElements();
        final int maxWidth = IconUtil.getMaxIconWidth(children);
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)children[i];
                final Icon icon = b.getIcon();
                b.setIcon(new Icon(){

                    @Override
                    public int getIconHeight() {
                        return icon == null ? 1 : icon.getIconHeight();
                    }

                    @Override
                    public int getIconWidth() {
                        return maxWidth;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        if (icon != null) {
                            icon.paintIcon(c, g, x, y);
                        }
                    }
                });
            }
            MenuUtil.align((MenuElement)children[i]);
            ++i;
        }
    }
}

