/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;

public class PopupMenuBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Insets INSETS = new Insets(3, 1, 2, 1);
    private Color highlightColor;
    private Color shadowColor;

    public PopupMenuBorder(Color highlightColor, Color shadowColor) {
        this.highlightColor = highlightColor;
        this.shadowColor = shadowColor;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.shadowColor);
        g.drawRect(x, y, width - 1, height - 1);
        g.setColor(this.highlightColor);
        GraphicsUtil.drawOptimizedLine(g, x + 1, y + 1, x + width - 2, y + 1);
        GraphicsUtil.drawOptimizedLine(g, x + 1, y + 2, x + 1, y + 2);
        GraphicsUtil.drawOptimizedLine(g, x + 1, y + height - 2, x + 1, y + height - 2);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }
}

