/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Dimension;
import java.awt.Insets;
import net.infonode.util.Direction;

public class DimensionUtil {
    public static final Dimension ZERO = new Dimension(0, 0);

    public static Dimension min(Dimension d1, Dimension d2) {
        return new Dimension(Math.min((int)d1.getWidth(), (int)d2.getWidth()), Math.min((int)d1.getHeight(), (int)d2.getHeight()));
    }

    public static Dimension max(Dimension d1, Dimension d2) {
        return new Dimension(Math.max((int)d1.getWidth(), (int)d2.getWidth()), Math.max((int)d1.getHeight(), (int)d2.getHeight()));
    }

    public static Dimension getInnerDimension(Dimension d, Insets i) {
        return new Dimension((int)(d.getWidth() - (double)i.left - (double)i.right), (int)(d.getHeight() - (double)i.top - (double)i.bottom));
    }

    public static Dimension add(Dimension dim, Insets insets) {
        return new Dimension(dim.width + insets.left + insets.right, dim.height + insets.top + insets.bottom);
    }

    public static Dimension add(Dimension d1, Dimension d2, boolean isHorizontalAdd) {
        return new Dimension(isHorizontalAdd ? d1.width + d2.width : Math.max(d1.width, d2.width), isHorizontalAdd ? Math.max(d1.height, d2.height) : d1.height + d2.height);
    }

    public static Dimension rotate(Direction source, Dimension d, Direction destination) {
        if (source.isHorizontal() && destination.isHorizontal()) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }
}

