/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules.syntax;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.library.modules.ArchModules;
import com.tngtech.archunit.library.modules.syntax.AbstractGivenModulesInternal;
import com.tngtech.archunit.library.modules.syntax.DescriptorFunction;
import com.tngtech.archunit.library.modules.syntax.GivenModules;
import com.tngtech.archunit.library.modules.syntax.GivenModulesByAnnotation;
import com.tngtech.archunit.library.modules.syntax.GivenModulesConjunction;
import com.tngtech.archunit.library.modules.syntax.ModulesShould;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import java.util.function.Predicate;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class ModuleRuleDefinition {
    private ModuleRuleDefinition() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static Creator modules() {
        return new Creator();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class Creator {
        private Creator() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public GenericDefinition definedBy(DescribedFunction<JavaClass, ArchModule.Identifier> identifierFunction) {
            return new GenericDefinition(identifierFunction);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public RootClassesDefinition<ArchModule.Descriptor> definedByRootClasses(DescribedPredicate<? super JavaClass> predicate) {
            return RootClassesDefinition.create(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public <A extends Annotation> GivenModulesByAnnotation<A> definedByAnnotation(Class<A> annotationType) {
            return (GivenModulesByAnnotation)new AbstractGivenModulesInternal.GivenModulesByAnnotationInternal(classes -> ArchModules.defineByAnnotation(annotationType).modularize((JavaClasses)classes)).as("modules defined by annotation @%s", new Object[]{annotationType.getSimpleName()});
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public PackagesDefinition definedByPackages(String packageIdentifier) {
            return new PackagesDefinition(packageIdentifier);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public <A extends Annotation> GivenModulesByAnnotation<A> definedByAnnotation(Class<A> annotationType, Function<A, String> nameFunction) {
            return (GivenModulesByAnnotation)new AbstractGivenModulesInternal.GivenModulesByAnnotationInternal(classes -> ArchModules.defineByAnnotation(annotationType, nameFunction).modularize((JavaClasses)classes)).as("modules defined by annotation @%s", new Object[]{annotationType.getSimpleName()});
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class GenericDefinition {
        private final DescribedFunction<JavaClass, ArchModule.Identifier> identifierFunction;

        private GenericDefinition(DescribedFunction<JavaClass, ArchModule.Identifier> identifierFunction) {
            this.identifierFunction = identifierFunction;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public <D extends ArchModule.Descriptor> GivenModules<D> derivingModule(DescriptorFunction<D> descriptorFunction) {
            return new AbstractGivenModulesInternal.GivenModulesInternal(classes -> ArchModules.defineBy(this.identifierFunction::apply).describeBy(descriptorFunction::apply).modularize((JavaClasses)classes)).as("modules defined by %s deriving module %s", new Object[]{this.identifierFunction.getDescription(), descriptorFunction.getDescription()});
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class PackagesDefinition
    implements GivenModules<ArchModule.Descriptor> {
        private final String description;
        private final ArchModules.Creator creator;

        PackagesDefinition(String packageIdentifier) {
            this(ArchModules.defineByPackages(packageIdentifier), String.format("modules defined by packages '%s'", packageIdentifier));
        }

        private PackagesDefinition(ArchModules.Creator creator, String description) {
            this.creator = creator;
            this.description = description;
        }

        private GivenModules<ArchModule.Descriptor> newGivenModules() {
            return new AbstractGivenModulesInternal.GivenModulesInternal(classes -> this.creator.modularize((JavaClasses)classes)).as(this.description, new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public PackagesDefinition derivingNameFromPattern(String namePattern) {
            return new PackagesDefinition(this.creator.deriveNameFromPattern(namePattern), this.description + String.format(" deriving name from pattern '%s'", namePattern));
        }

        @Override
        public ArchRule should(ArchCondition<? super ArchModule<ArchModule.Descriptor>> condition) {
            return this.newGivenModules().should(condition);
        }

        @Override
        public GivenModulesConjunction<ArchModule.Descriptor> that(DescribedPredicate<? super ArchModule<ArchModule.Descriptor>> predicate) {
            return this.newGivenModules().that((DescribedPredicate)predicate);
        }

        @Override
        public ModulesShould<ArchModule.Descriptor> should() {
            return this.newGivenModules().should();
        }

        @Override
        public GivenModules<ArchModule.Descriptor> as(String description, Object ... args) {
            return this.newGivenModules().as(description, args);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class RootClassesDefinition<DESCRIPTOR extends ArchModule.Descriptor>
    implements GivenModules<DESCRIPTOR> {
        private final Predicate<? super JavaClass> rootClassPredicate;
        private final Function<? super JavaClass, DESCRIPTOR> descriptorFunction;
        private final String description;

        private RootClassesDefinition(Predicate<? super JavaClass> rootClassPredicate, Function<? super JavaClass, DESCRIPTOR> descriptorFunction, String description) {
            this.rootClassPredicate = rootClassPredicate;
            this.descriptorFunction = descriptorFunction;
            this.description = description;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public <D extends ArchModule.Descriptor> GivenModules<D> derivingModuleFromRootClassBy(DescribedFunction<? super JavaClass, D> descriptorFunction) {
            return new RootClassesDefinition<D>(this.rootClassPredicate, descriptorFunction, this.description + " deriving module from root class by " + descriptorFunction.getDescription());
        }

        @Override
        public ArchRule should(ArchCondition<? super ArchModule<DESCRIPTOR>> condition) {
            return this.newGivenModules().should(condition);
        }

        @Override
        public GivenModulesConjunction<DESCRIPTOR> that(DescribedPredicate<? super ArchModule<DESCRIPTOR>> predicate) {
            return this.newGivenModules().that((DescribedPredicate)predicate);
        }

        @Override
        public ModulesShould<DESCRIPTOR> should() {
            return this.newGivenModules().should();
        }

        @Override
        public GivenModules<DESCRIPTOR> as(String description, Object ... args) {
            return this.newGivenModules().as(description, args);
        }

        private GivenModules<DESCRIPTOR> newGivenModules() {
            return new AbstractGivenModulesInternal.GivenModulesInternal(classes -> ArchModules.defineByRootClasses(this.rootClassPredicate).describeModuleByRootClass((__, rootClass) -> (ArchModule.Descriptor)this.descriptorFunction.apply(rootClass)).modularize((JavaClasses)classes)).as(this.description, new Object[0]);
        }

        private static RootClassesDefinition<ArchModule.Descriptor> create(DescribedPredicate<? super JavaClass> rootClassPredicate) {
            return new RootClassesDefinition<ArchModule.Descriptor>(rootClassPredicate, javaClass -> ArchModule.Descriptor.create(javaClass.getPackageName()), "modules defined by root classes " + rootClassPredicate.getDescription());
        }
    }
}

