/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.library.dependencies.Slice;
import com.tngtech.archunit.library.dependencies.Slices;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class SliceRule
implements ArchRule {
    private final Slices.Transformer inputTransformer;
    private final Priority priority;
    private final List<ArchRule.Transformation> transformations;
    private final DescribedPredicate<Dependency> ignoreDependency;
    private final ConditionFactory conditionFactory;
    private final Optional<Boolean> allowEmptyShould;

    SliceRule(Slices.Transformer inputTransformer, Priority priority, ConditionFactory conditionFactory) {
        this(inputTransformer, priority, Collections.emptyList(), DescribedPredicate.alwaysFalse(), conditionFactory, Optional.empty());
    }

    private SliceRule(Slices.Transformer inputTransformer, Priority priority, List<ArchRule.Transformation> transformations, DescribedPredicate<Dependency> ignoreDependency, ConditionFactory conditionFactory, Optional<Boolean> allowEmptyShould) {
        this.inputTransformer = inputTransformer;
        this.priority = priority;
        this.transformations = transformations;
        this.ignoreDependency = ignoreDependency;
        this.conditionFactory = conditionFactory;
        this.allowEmptyShould = allowEmptyShould;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void check(JavaClasses classes) {
        this.getArchRule().check(classes);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SliceRule because(String reason) {
        return this.copyWithTransformation(new ArchRule.Transformation.Because(reason));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ArchRule allowEmptyShould(boolean allowEmptyShould) {
        return new SliceRule(this.inputTransformer, this.priority, this.transformations, this.ignoreDependency, this.conditionFactory, Optional.of(allowEmptyShould));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult evaluate(JavaClasses classes) {
        return this.getArchRule().evaluate(classes);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return this.getArchRule().getDescription();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SliceRule as(String newDescription) {
        return this.copyWithTransformation(new ArchRule.Transformation.As(newDescription));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SliceRule ignoreDependency(Class<?> origin, Class<?> target) {
        return this.ignoreDependency(JavaClass.Predicates.equivalentTo(origin), JavaClass.Predicates.equivalentTo(target));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SliceRule ignoreDependency(String origin, String target) {
        return this.ignoreDependency(HasName.Predicates.name(origin), HasName.Predicates.name(target));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SliceRule ignoreDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
        return new SliceRule(this.inputTransformer, this.priority, this.transformations, this.ignoreDependency.or(Dependency.Predicates.dependency(origin, target)), this.conditionFactory, this.allowEmptyShould);
    }

    private SliceRule copyWithTransformation(ArchRule.Transformation transformation) {
        ImmutableCollection newTransformations = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.transformations)).add(transformation)).build();
        return new SliceRule(this.inputTransformer, this.priority, (List<ArchRule.Transformation>)((Object)newTransformations), this.ignoreDependency, this.conditionFactory, this.allowEmptyShould);
    }

    private ArchRule getArchRule() {
        ArchRule rule = ArchRuleDefinition.priority(this.priority).all(this.inputTransformer).should(this.conditionFactory.create(this.inputTransformer, DescribedPredicate.not(this.ignoreDependency)));
        if (this.allowEmptyShould.isPresent()) {
            rule = rule.allowEmptyShould(this.allowEmptyShould.get());
        }
        for (ArchRule.Transformation transformation : this.transformations) {
            rule = transformation.apply(rule);
        }
        return rule;
    }

    public String toString() {
        return this.getDescription();
    }

    static interface ConditionFactory {
        public ArchCondition<Slice> create(Slices.Transformer var1, DescribedPredicate<Dependency> var2);
    }
}

