/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public abstract class DescribedPredicate<T>
implements Predicate<T> {
    private final String description;
    private static final DescribedPredicate<Object> ALWAYS_TRUE = new DescribedPredicate<Object>("always true", new Object[0]){

        @Override
        public boolean test(Object input) {
            return true;
        }
    };
    private static final DescribedPredicate<Object> ALWAYS_FALSE = new DescribedPredicate<Object>("always false", new Object[0]){

        @Override
        public boolean test(Object input) {
            return false;
        }
    };
    private static final DescribedPredicate<Iterable<?>> EMPTY = new DescribedPredicate<Iterable<?>>("empty", new Object[0]){

        @Override
        public boolean test(Iterable<?> input) {
            return Iterables.isEmpty(input);
        }
    };
    private static final DescribedPredicate<Optional<?>> OPTIONAL_EMPTY = new DescribedPredicate<Optional<?>>("empty", new Object[0]){

        @Override
        public boolean test(Optional<?> input) {
            return !input.isPresent();
        }
    };

    public DescribedPredicate(String description, Object ... params) {
        Preconditions.checkArgument(description != null, "Description must be set");
        this.description = String.format(description, params);
    }

    public String getDescription() {
        return this.description;
    }

    public DescribedPredicate<T> as(String description, Object ... params) {
        return new AsPredicate(this, description, params);
    }

    @Override
    public DescribedPredicate<T> and(DescribedPredicate<? super T> other) {
        return new AndPredicate<T>(this, other);
    }

    @Override
    public DescribedPredicate<T> or(DescribedPredicate<? super T> other) {
        return new OrPredicate<T>(this, other);
    }

    public <F> DescribedPredicate<F> onResultOf(Function<? super F, ? extends T> function) {
        return new OnResultOfPredicate<F, T>(this, function);
    }

    public final <U extends T> DescribedPredicate<U> forSubtype() {
        return this;
    }

    public String toString() {
        return this.getDescription();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> equalTo(T object) {
        return new EqualToPredicate<T>(object);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends Comparable<T>> DescribedPredicate<T> lessThan(T value) {
        return new LessThanPredicate<T>(value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends Comparable<T>> DescribedPredicate<T> greaterThan(T value) {
        return new GreaterThanPredicate<T>(value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends Comparable<T>> DescribedPredicate<T> lessThanOrEqualTo(T value) {
        return new LessThanOrEqualToPredicate<T>(value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends Comparable<T>> DescribedPredicate<T> greaterThanOrEqualTo(T value) {
        return new GreaterThanOrEqualToPredicate<T>(value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> describe(String description, Predicate<? super T> predicate) {
        return new DescribePredicate<T>(description, predicate).forSubtype();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> doesNot(DescribedPredicate<? super T> predicate) {
        return DescribedPredicate.not(predicate).as("does not %s", predicate.getDescription()).forSubtype();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> doNot(DescribedPredicate<? super T> predicate) {
        return DescribedPredicate.not(predicate).as("do not %s", predicate.getDescription()).forSubtype();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> not(DescribedPredicate<? super T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    @SafeVarargs
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> and(DescribedPredicate<? super T> ... predicates) {
        return DescribedPredicate.and(ImmutableList.copyOf(predicates));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> and(Iterable<? extends DescribedPredicate<? super T>> predicates) {
        return DescribedPredicate.joinPredicates(predicates, (a, b) -> a.and((DescribedPredicate)b));
    }

    @SafeVarargs
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> or(DescribedPredicate<? super T> ... predicates) {
        return DescribedPredicate.or(ImmutableList.copyOf(predicates));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<T> or(Iterable<? extends DescribedPredicate<? super T>> predicates) {
        return DescribedPredicate.joinPredicates(predicates, (a, b) -> a.or((DescribedPredicate)b));
    }

    private static <T> DescribedPredicate<T> joinPredicates(Iterable<? extends DescribedPredicate<? super T>> predicates, BinaryOperator<DescribedPredicate<T>> predicateJoinOperation) {
        if (Iterables.isEmpty(predicates)) {
            return DescribedPredicate.alwaysFalse();
        }
        if (Iterables.size(predicates) == 1) {
            return Iterables.getOnlyElement(predicates).forSubtype();
        }
        return StreamSupport.stream(predicates.spliterator(), false).map(it -> it).reduce(predicateJoinOperation).get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static DescribedPredicate<Iterable<?>> empty() {
        return EMPTY;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<Optional<T>> optionalContains(DescribedPredicate<? super T> predicate) {
        return new OptionalContainsPredicate<T>(predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<Optional<T>> optionalEmpty() {
        return OPTIONAL_EMPTY;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<Iterable<? extends T>> anyElementThat(DescribedPredicate<? super T> predicate) {
        return new AnyElementPredicate<T>(predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> DescribedPredicate<Iterable<T>> allElements(DescribedPredicate<? super T> predicate) {
        return new AllElementsPredicate<T>(predicate);
    }

    private static class AsPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> current;

        AsPredicate(DescribedPredicate<T> current, String description, Object ... params) {
            super(description, params);
            this.current = current;
        }

        @Override
        public boolean test(T input) {
            return this.current.test(input);
        }
    }

    private static class AndPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> current;
        private final DescribedPredicate<? super T> other;

        AndPredicate(DescribedPredicate<T> current, DescribedPredicate<? super T> other) {
            super(current.getDescription() + " and " + other.getDescription(), new Object[0]);
            this.current = Preconditions.checkNotNull(current);
            this.other = Preconditions.checkNotNull(other);
        }

        @Override
        public boolean test(T input) {
            return this.current.test(input) && this.other.test(input);
        }
    }

    private static class OrPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> current;
        private final DescribedPredicate<? super T> other;

        OrPredicate(DescribedPredicate<T> current, DescribedPredicate<? super T> other) {
            super(current.getDescription() + " or " + other.getDescription(), new Object[0]);
            this.current = Preconditions.checkNotNull(current);
            this.other = Preconditions.checkNotNull(other);
        }

        @Override
        public boolean test(T input) {
            return this.current.test(input) || this.other.test(input);
        }
    }

    private static class OnResultOfPredicate<F, T>
    extends DescribedPredicate<F> {
        private final DescribedPredicate<T> current;
        private final Function<? super F, ? extends T> function;

        OnResultOfPredicate(DescribedPredicate<T> current, Function<? super F, ? extends T> function) {
            super(current.getDescription(), new Object[0]);
            this.current = Preconditions.checkNotNull(current);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean test(F input) {
            return this.current.test(this.function.apply(input));
        }
    }

    private static class EqualToPredicate<T>
    extends DescribedPredicate<T> {
        private final T value;

        EqualToPredicate(T value) {
            super("equal to '%s'", value);
            this.value = Preconditions.checkNotNull(value);
        }

        @Override
        public boolean test(T input) {
            return this.value.equals(input);
        }
    }

    private static class LessThanPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        LessThanPredicate(T value) {
            super("less than '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean test(T input) {
            return input.compareTo(this.value) < 0;
        }
    }

    private static class GreaterThanPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        GreaterThanPredicate(T value) {
            super("greater than '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean test(T input) {
            return input.compareTo(this.value) > 0;
        }
    }

    private static class LessThanOrEqualToPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        LessThanOrEqualToPredicate(T value) {
            super("less than or equal to '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean test(T input) {
            return input.compareTo(this.value) <= 0;
        }
    }

    private static class GreaterThanOrEqualToPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        GreaterThanOrEqualToPredicate(T value) {
            super("greater than or equal to '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean test(T input) {
            return input.compareTo(this.value) >= 0;
        }
    }

    private static class DescribePredicate<T>
    extends DescribedPredicate<T> {
        private final Predicate<T> delegate;

        DescribePredicate(String description, Predicate<T> predicate) {
            super(description, new Object[0]);
            this.delegate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean test(T input) {
            return this.delegate.test(input);
        }
    }

    private static class NotPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> predicate;

        NotPredicate(DescribedPredicate<? super T> predicate) {
            super("not " + predicate.getDescription(), new Object[0]);
            this.predicate = Preconditions.checkNotNull(predicate).forSubtype();
        }

        @Override
        public boolean test(T input) {
            return !this.predicate.test(input);
        }
    }

    private static class OptionalContainsPredicate<T>
    extends DescribedPredicate<Optional<T>> {
        private final DescribedPredicate<T> predicate;

        OptionalContainsPredicate(DescribedPredicate<? super T> predicate) {
            super("contains " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubtype();
        }

        @Override
        public boolean test(Optional<T> optional) {
            return optional.isPresent() && this.predicate.test(optional.get());
        }
    }

    private static class AnyElementPredicate<T>
    extends DescribedPredicate<Iterable<? extends T>> {
        private final DescribedPredicate<T> predicate;

        AnyElementPredicate(DescribedPredicate<? super T> predicate) {
            super("any element that " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubtype();
        }

        @Override
        public boolean test(Iterable<? extends T> iterable) {
            for (T javaClass : iterable) {
                if (!this.predicate.test(javaClass)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AllElementsPredicate<T>
    extends DescribedPredicate<Iterable<T>> {
        private final DescribedPredicate<T> predicate;

        AllElementsPredicate(DescribedPredicate<? super T> predicate) {
            super("all elements " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubtype();
        }

        @Override
        public boolean test(Iterable<T> iterable) {
            for (T javaClass : iterable) {
                if (this.predicate.test(javaClass)) continue;
                return false;
            }
            return true;
        }
    }
}

