/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionInfoPermissions;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo {
    private ConditionalPermissionInfoStorage cpis;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfo[] permissionInfos;
    private final String access;
    private final FrameworkContext framework;
    private final Debug debug;
    private String name;
    private PermissionCollection permissions;
    static final Class<?>[] argClasses = new Class[]{Bundle.class, ConditionInfo.class};

    ConditionalPermissionInfoImpl(ConditionalPermissionInfoStorage cpis, String name, ConditionInfo[] conds, PermissionInfo[] perms, String access, FrameworkContext fw) {
        this.cpis = cpis;
        this.name = name;
        this.conditionInfos = conds;
        this.permissionInfos = perms;
        this.access = access;
        this.framework = fw;
        this.debug = fw.debug;
        this.permissions = null;
    }

    ConditionalPermissionInfoImpl(ConditionalPermissionInfoStorage cpis, String encoded, FrameworkContext fw) {
        this.cpis = cpis;
        this.framework = fw;
        this.debug = fw.debug;
        try {
            char[] eca = encoded.toCharArray();
            int pos = PermUtil.skipWhite(eca, 0);
            if (!(eca[pos] != 'A' && eca[pos] != 'a' || eca[pos + 1] != 'L' && eca[pos + 1] != 'l' || eca[pos + 2] != 'L' && eca[pos + 2] != 'l' || eca[pos + 3] != 'O' && eca[pos + 3] != 'o' || eca[pos + 4] != 'W' && eca[pos + 4] != 'w' || eca[pos + 5] != ' ')) {
                pos += 6;
                this.access = "allow";
            } else if (!(eca[pos] != 'D' && eca[pos] != 'd' || eca[pos + 1] != 'E' && eca[pos + 1] != 'e' || eca[pos + 2] != 'N' && eca[pos + 2] != 'n' || eca[pos + 3] != 'Y' && eca[pos + 3] != 'y' || eca[pos + 4] != ' ')) {
                pos += 5;
                this.access = "deny";
            } else {
                throw new IllegalArgumentException("Access must be allow or deny");
            }
            pos = PermUtil.skipWhite(eca, pos);
            if (eca[pos++] != '{') {
                throw new IllegalArgumentException("Missing open brace");
            }
            ArrayList<ConditionInfo> cal = new ArrayList<ConditionInfo>();
            ArrayList<PermissionInfo> pal = new ArrayList<PermissionInfo>();
            boolean seenPermInfo = false;
            while (true) {
                char ec;
                pos = PermUtil.skipWhite(eca, pos);
                char c = eca[pos];
                if (!seenPermInfo && c == '[') {
                    ec = ']';
                } else if (c == '(') {
                    ec = ')';
                    seenPermInfo = true;
                } else {
                    if (c == '}') {
                        ++pos;
                        break;
                    }
                    throw new IllegalArgumentException("Unexpected char '" + c + "' at pos " + pos);
                }
                int start_pos = pos++;
                do {
                    if ((c = eca[pos]) == '\"') {
                        pos = PermUtil.unquote(eca, pos, null);
                        continue;
                    }
                    ++pos;
                } while (c != ec);
                String info = new String(eca, start_pos, pos - start_pos);
                if (c == ']') {
                    cal.add(new ConditionInfo(info));
                    continue;
                }
                pal.add(new PermissionInfo(info));
            }
            if (!seenPermInfo) {
                throw new IllegalArgumentException("Permissions must contain atleast one element");
            }
            if ((pos = PermUtil.endOfString(eca, pos, eca.length)) != -1) {
                StringBuffer buf = new StringBuffer();
                pos = PermUtil.unquote(eca, pos, buf);
                this.name = buf.toString();
                if ((pos = PermUtil.endOfString(eca, pos, eca.length)) != -1) {
                    throw new IllegalArgumentException("Unexpected characters at end of string: " + new String(eca, pos, eca.length - pos));
                }
            } else {
                this.name = null;
            }
            this.conditionInfos = cal.toArray(new ConditionInfo[cal.size()]);
            this.permissionInfos = pal.toArray(new PermissionInfo[pal.size()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unexpected end of string");
        }
    }

    @Override
    public ConditionInfo[] getConditionInfos() {
        return this.conditionInfos;
    }

    @Override
    public PermissionInfo[] getPermissionInfos() {
        return this.permissionInfos;
    }

    @Override
    public void delete() {
        if (this.cpis == null) {
            throw new UnsupportedOperationException("Not in use");
        }
        this.cpis.remove(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAccessDecision() {
        return this.access;
    }

    @Override
    public String getEncoded() {
        StringBuffer res = new StringBuffer(this.access);
        res.append(" { ");
        if (this.conditionInfos != null) {
            for (ConditionInfo conditionInfo : this.conditionInfos) {
                res.append(conditionInfo.getEncoded());
                res.append(' ');
            }
        }
        if (this.permissionInfos != null) {
            for (PermissionInfo permissionInfo : this.permissionInfos) {
                res.append(permissionInfo.getEncoded());
                res.append(' ');
            }
        }
        res.append('}');
        if (this.name != null) {
            res.append(' ');
            PermUtil.quote(this.name, res);
        }
        return res.toString();
    }

    @Override
    public String toString() {
        return this.getEncoded();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ConditionalPermissionInfo cpi = (ConditionalPermissionInfo)obj;
        if (this.name == null ? cpi.getName() != null : !this.name.equals(cpi.getName())) {
            return false;
        }
        if (!Arrays.equals(this.permissionInfos, cpi.getPermissionInfos())) {
            return false;
        }
        if (!Arrays.equals(this.conditionInfos, cpi.getConditionInfos())) {
            return false;
        }
        return this.access == cpi.getAccessDecision();
    }

    @Override
    public final int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        int res = this.conditionInfos != null && this.conditionInfos.length > 0 ? this.conditionInfos[0].hashCode() : 0;
        return res + this.permissionInfos[0].hashCode();
    }

    ConditionalPermission getConditionalPermission(Bundle bundle) {
        String me = "ConditionalPermissionInfoImpl.getConditionalPermission: ";
        ArrayList<Condition> conds = new ArrayList<Condition>(this.conditionInfos == null ? 0 : this.conditionInfos.length);
        if (this.conditionInfos != null) {
            for (ConditionInfo conditionInfo : this.conditionInfos) {
                try {
                    Condition c;
                    Class<?> clazz = Class.forName(conditionInfo.getType(), true, this.framework.getClassLoader(null));
                    Constructor<?> cons = null;
                    Method method = null;
                    try {
                        method = clazz.getMethod("getCondition", argClasses);
                        if ((method.getModifiers() & 8) == 0) {
                            method = null;
                        }
                    }
                    catch (NoSuchMethodException ignore) {
                        // empty catch block
                    }
                    if (method != null) {
                        if (this.debug.permissions) {
                            this.debug.println("ConditionalPermissionInfoImpl.getConditionalPermission: Invoke, " + method + " for bundle " + bundle);
                        }
                        c = (Condition)method.invoke(null, bundle, conditionInfo);
                    } else {
                        try {
                            cons = clazz.getConstructor(argClasses);
                        }
                        catch (NoSuchMethodException ignore) {
                            // empty catch block
                        }
                        if (cons != null) {
                            if (this.debug.permissions) {
                                this.debug.println("ConditionalPermissionInfoImpl.getConditionalPermission: Construct, " + cons + " for bundle " + bundle);
                            }
                            c = (Condition)cons.newInstance(bundle, conditionInfo);
                        } else {
                            this.debug.println("NYI! Log faulty ConditionInfo object!?");
                            continue;
                        }
                    }
                    if (!c.isMutable() && !c.isPostponed()) {
                        if (c.isSatisfied()) {
                            if (!this.debug.permissions) continue;
                            this.debug.println("ConditionalPermissionInfoImpl.getConditionalPermission: Immutable condition ok, continue");
                            continue;
                        }
                        if (this.debug.permissions) {
                            this.debug.println("ConditionalPermissionInfoImpl.getConditionalPermission: Immutable condition NOT ok, abort");
                        }
                        return null;
                    }
                    conds.add(c);
                }
                catch (Throwable t) {
                    this.debug.printStackTrace("NYI! Log failed Condition creation", t);
                    return null;
                }
            }
        }
        Condition[] conditions = conds.toArray(new Condition[conds.size()]);
        return new ConditionalPermission(conditions, this.getPermissions(), this.access, this);
    }

    PermissionCollection getPermissions() {
        if (this.permissions == null) {
            this.permissions = new PermissionInfoPermissions(this.framework, null, this.permissionInfos);
        }
        return this.permissions;
    }

    void setPermissionInfoStorage(ConditionalPermissionInfoStorage storage) {
        this.cpis = storage;
    }

    void setName(String newName) {
        this.name = newName;
    }
}

