/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class TextPainter {
    private final int lineHeight;
    private final int textHeight;
    private final int textWidth;
    private final String[] lines;
    private final Graphics2D g;

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public TextPainter(Graphics2D g, String text) {
        this.g = g;
        this.lines = text.split("\n");
        FontMetrics fontMetrics = g.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight();
        this.textHeight = this.lineHeight * this.lines.length + fontMetrics.getDescent();
        int textWidth = 0;
        for (String line : this.lines) {
            int w = fontMetrics.stringWidth(line);
            textWidth = Math.max(textWidth, w);
        }
        this.textWidth = textWidth;
    }

    public void draw(int x, int y, Color textColor, Color bgColor) {
        Color oldColor = this.g.getColor();
        Stroke oldStroke = this.g.getStroke();
        this.g.setColor(bgColor);
        this.g.setStroke(new BasicStroke(0.5f));
        this.g.fillRect(x, y, this.textWidth, this.textHeight);
        this.g.setColor(textColor);
        for (String line : this.lines) {
            this.g.drawString(line, x, y += this.lineHeight);
        }
        this.g.setColor(oldColor);
        this.g.setStroke(oldStroke);
    }
}

