/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.regex.Pattern;
import org.freeplane.features.filter.StringMatchingStrategy;

public class ExactStringMatchingStrategy
implements StringMatchingStrategy {
    @Override
    public boolean matches(String searchTerm, String searchText, StringMatchingStrategy.Type matchType) {
        switch (matchType) {
            case ALL: {
                return searchText.equals(searchTerm);
            }
            case WORDWISE: {
                return Pattern.compile("\\b" + Pattern.quote(searchTerm) + "\\b").matcher(searchText).find();
            }
            case SUBSTRING: {
                return searchText.contains(searchTerm);
            }
        }
        return false;
    }
}

