/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.freeplane.core.util.TextUtils;

public class UndoEnabler {
    public static final String UNDO_ACTION = "Undo";
    public static final String REDO_ACTION = "Redo";

    public static void addUndoRedoFunctionality(JTextComponent textfield) {
        final UndoManager undo = new UndoManager();
        Document doc = textfield.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        AbstractAction undoAction = new AbstractAction(TextUtils.getText("UndoAction.text")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        };
        undoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Z"));
        textfield.getActionMap().put(UNDO_ACTION, undoAction);
        textfield.getInputMap().put(KeyStroke.getKeyStroke("control Z"), UNDO_ACTION);
        AbstractAction redoAction = new AbstractAction(TextUtils.getText("RedoAction.text")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        };
        redoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Y"));
        textfield.getActionMap().put(REDO_ACTION, redoAction);
        textfield.getInputMap().put(KeyStroke.getKeyStroke("control Y"), REDO_ACTION);
    }
}

