/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class SecurityUtils {
    public static String ECRYPTION_ALGORYTHM = "MD5";
    private static Random random;
    private static Random secureRand;
    public static final int DEFAULT_PASSWORD_LENGTH = 8;
    public static final char[] PASSWORD_ALPHABET;
    private static final boolean DISABLE_SECURE_MASKING;
    private static final String SECURE_REPLACEMENT_MASK = "*****";

    static {
        secureRand = new Random(System.currentTimeMillis());
        long secureInitializer = secureRand.nextLong();
        random = new Random(secureInitializer);
        PASSWORD_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        DISABLE_SECURE_MASKING = CommonUtils.toBoolean(System.getProperty("dbeaver.disable.secure.masking"));
    }

    public static String generateGUID(boolean secure) {
        byte[] array;
        String localHostAddr;
        try {
            InetAddress id = InetAddress.getLocalHost();
            localHostAddr = id.toString();
        }
        catch (UnknownHostException unknownHostException) {
            localHostAddr = "localhost";
        }
        long time = System.currentTimeMillis();
        long rand = secure ? secureRand.nextLong() : random.nextLong();
        StringBuilder sb = new StringBuilder(32);
        sb.append(localHostAddr).append(":").append(Long.toString(time)).append(":").append(Long.toString(rand));
        try {
            MessageDigest md5 = MessageDigest.getInstance(ECRYPTION_ALGORYTHM);
            md5.update(sb.toString().getBytes(StandardCharsets.UTF_8));
            array = md5.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            array = new byte[16];
            random.nextBytes(array);
        }
        sb.setLength(0);
        int j = 0;
        while (j < array.length) {
            int b = array[j] & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
            ++j;
        }
        String raw = sb.toString().toUpperCase();
        sb.setLength(0);
        sb.append(raw.substring(0, 8));
        sb.append("-");
        sb.append(raw.substring(8, 12));
        sb.append("-");
        sb.append(raw.substring(12, 16));
        sb.append("-");
        sb.append(raw.substring(16, 20));
        sb.append("-");
        sb.append(raw.substring(20));
        return sb.toString();
    }

    public static String generateUniqueId() {
        long curTime = System.currentTimeMillis();
        int random = secureRand.nextInt();
        if (random < 0) {
            random = -random;
        }
        return Long.toString(curTime, 36) + Integer.toString(random, 36);
    }

    public static String makeDigest(String userAlias, String userPassword) {
        try {
            if (userPassword == null) {
                userPassword = "";
            }
            MessageDigest md5 = MessageDigest.getInstance(ECRYPTION_ALGORYTHM);
            md5.update(userAlias.getBytes(StandardCharsets.UTF_8));
            return CommonUtils.toHexString(md5.digest(userPassword.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "*";
        }
    }

    public static String makeDigest(String userPassword) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(ECRYPTION_ALGORYTHM);
            return CommonUtils.toHexString(md5.digest(userPassword.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "*";
        }
    }

    public static String generatePassword(int length) {
        SecureRandom random = new SecureRandom();
        StringBuilder pass = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            pass.append(PASSWORD_ALPHABET[random.nextInt(PASSWORD_ALPHABET.length)]);
            ++i;
        }
        return pass.toString();
    }

    public static long generateRandomLong() {
        SecureRandom random = new SecureRandom();
        return random.nextLong();
    }

    public static byte[] generateRandomBytes(int length) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String generatePassword() {
        return SecurityUtils.generatePassword(8);
    }

    public static Random getRandom() {
        return random;
    }

    @NotNull
    public static String mask(@NotNull String input) {
        if (DISABLE_SECURE_MASKING) {
            return input;
        }
        if (input.length() > 2) {
            return input.charAt(0) + SECURE_REPLACEMENT_MASK + input.charAt(input.length() - 1);
        }
        return SECURE_REPLACEMENT_MASK;
    }
}

