/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.dict;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public enum DB2ConstraintType implements DBPNamedObject
{
    F("Foreign key", DBSEntityConstraintType.FOREIGN_KEY),
    I("Functional dependency", DBSEntityConstraintType.ASSOCIATION),
    K("Check", DBSEntityConstraintType.CHECK),
    P("Primary key", DBSEntityConstraintType.PRIMARY_KEY),
    U("Unique", DBSEntityConstraintType.UNIQUE_KEY);

    private String name;
    private DBSEntityConstraintType type;

    private DB2ConstraintType(String name, DBSEntityConstraintType type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return this.name;
    }

    public static DBSEntityConstraintType getConstraintType(String code) {
        return DB2ConstraintType.valueOf(code).getType();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public DBSEntityConstraintType getType() {
        return this.type;
    }
}

