/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolStatefulObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public abstract class ExasolTableBase
extends JDBCTable<ExasolDataSource, ExasolSchema>
implements DBPNamedObject2,
DBPRefreshableObject,
ExasolStatefulObject {
    private String remarks;
    private String objectType;
    private BigDecimal objectId;

    public ExasolTableBase(ExasolSchema schema, String name, boolean persisted) {
        super((DBSObject)schema, name, persisted);
    }

    public ExasolTableBase(DBRProgressMonitor monitor, ExasolSchema schema, ResultSet dbResult) {
        super((DBSObject)schema, true);
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TABLE"));
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        this.objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE");
        this.objectId = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"OBJECT_ID");
    }

    @Property(viewable=false, order=99, editable=true, updatable=true, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String description) {
        this.remarks = description;
    }

    public boolean isView() {
        return this.objectType.equals("VIEW");
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public abstract ExasolTableColumn getAttribute(@NotNull DBRProgressMonitor var1, @NotNull String var2) throws DBException;

    @Property(viewable=true, editable=false, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=false, order=2)
    public ExasolSchema getSchema() {
        return (ExasolSchema)super.getContainer();
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    @Nullable
    public Collection<ExasolTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public Collection<ExasolTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public BigDecimal getObjectId() {
        return this.objectId;
    }
}

