/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data;

import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.data.BinaryEditorPart;
import org.jkiss.dbeaver.ui.data.BinaryPanelEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueController;

public class BinaryStreamValueManager
implements IStreamValueManager {
    private static final Log log = Log.getLog(BinaryStreamValueManager.class);

    public IStreamValueManager.MatchType matchesTo(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject attribute, @Nullable DBDContent value) {
        if (value != null && "application/octet-stream".equals(value.getContentType())) {
            return IStreamValueManager.MatchType.DEFAULT;
        }
        return IStreamValueManager.MatchType.APPLIES;
    }

    public IStreamValueEditor createPanelEditor(@NotNull IValueController controller) throws DBException {
        return new BinaryPanelEditor();
    }

    public IEditorPart createEditorPart(@NotNull IValueController controller) {
        return new BinaryEditorPart();
    }
}

