/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IWorkbenchPage;

public abstract class NavigationLocation
implements INavigationLocation {
    private IWorkbenchPage page;
    private IEditorInput input;
    private String editorId;

    protected NavigationLocation(IEditorPart editorPart) {
        this.page = editorPart.getSite().getPage();
        this.editorId = editorPart.getSite().getId();
        this.input = editorPart.getEditorInput();
    }

    protected IEditorPart getEditorPart() {
        if (this.input == null) {
            return null;
        }
        if (this.editorId == null) {
            return this.page.findEditor(this.input);
        }
        IEditorReference[] editorReferences = this.page.findEditors(this.input, this.editorId, 3);
        if (editorReferences.length > 0) {
            return editorReferences[0].getEditor(false);
        }
        return null;
    }

    @Override
    public Object getInput() {
        return this.input;
    }

    @Override
    public String getId() {
        return this.editorId;
    }

    @Override
    public String getText() {
        IEditorPart part = this.getEditorPart();
        if (part == null) {
            return "";
        }
        return part.getTitle();
    }

    @Override
    public void setInput(Object input) {
        this.input = (IEditorInput)input;
    }

    @Override
    public void setId(String id) {
        this.editorId = id;
    }

    @Override
    public void dispose() {
        this.releaseState();
    }

    @Override
    public void releaseState() {
        this.input = null;
    }
}

