/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;

public class UIExecutionQueue {
    private static final List<Runnable> execQueue = new ArrayList<Runnable>();
    private static int runCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueExec(Runnable runnable) {
        List<Runnable> list = execQueue;
        synchronized (list) {
            execQueue.add(runnable);
        }
        UIUtils.asyncExec(UIExecutionQueue::executeInUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockQueue() {
        List<Runnable> list = execQueue;
        synchronized (list) {
            ++runCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unblockQueue() {
        List<Runnable> list = execQueue;
        synchronized (list) {
            if (runCount <= 0) {
                throw new IllegalStateException("Queue is unblocked");
            }
            --runCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeInUI() {
        Runnable nextJob;
        List<Runnable> list = execQueue;
        synchronized (list) {
            DBPPlatformDesktop pd;
            DBPPlatform dBPPlatform = DBWorkbench.getPlatform();
            boolean workbenchStarted = dBPPlatform instanceof DBPPlatformDesktop && (pd = (DBPPlatformDesktop)dBPPlatform).isWorkbenchStarted();
            ProgressManager progressManager = ProgressManager.getInstance();
            boolean isUserTaskRunning = Arrays.stream(progressManager.getJobInfos(false)).map(JobInfo::getJob).filter(Objects::nonNull).anyMatch(Job::isUser);
            if (runCount > 0 || !workbenchStarted || isUserTaskRunning) {
                if (!DBWorkbench.getPlatform().isShuttingDown()) {
                    UIUtils.asyncExec(UIExecutionQueue::executeInUI);
                }
                return;
            }
            if (execQueue.isEmpty()) {
                return;
            }
            ++runCount;
            nextJob = execQueue.remove(0);
        }
        try {
            nextJob.run();
        }
        catch (Throwable throwable) {
            List<Runnable> list2 = execQueue;
            synchronized (list2) {
                --runCount;
            }
            throw throwable;
        }
        List<Runnable> list3 = execQueue;
        synchronized (list3) {
            --runCount;
        }
        UIUtils.asyncExec(UIExecutionQueue::executeInUI);
    }
}

