/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.multiobjective;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IIntegerPBSolver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.IntegerVariable;
import org.sat4j.pb.multiobjective.IMultiObjOptimizationProblem;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;

public class LeximinDecorator
extends LexicoDecoratorPB
implements IMultiObjOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private final List<ObjectiveFunction> initObjs = new ArrayList<ObjectiveFunction>();
    private boolean initDone = false;
    private final List<IntegerVariable> objBoundVariables = new ArrayList<IntegerVariable>();
    private final IIntegerPBSolver integerSolver;
    private final List<IVecInt> atLeastFlags = new ArrayList<IVecInt>();

    public LeximinDecorator(IIntegerPBSolver solver) {
        super(solver);
        this.integerSolver = solver;
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        if (!this.initDone) {
            this.init();
            this.initDone = true;
        }
        return super.admitABetterSolution(assumps);
    }

    private void init() {
        this.setInitConstraints();
        this.objs = new ArrayList<ObjectiveFunction>();
        for (IntegerVariable boundVar : this.objBoundVariables) {
            Vec weights = new Vec();
            BigInteger factor = BigInteger.ONE;
            for (int i = 0; i < boundVar.getVars().size(); ++i) {
                weights.push((Object)factor);
                factor = factor.shiftLeft(1);
            }
            this.objs.add(new ObjectiveFunction(boundVar.getVars(), (IVec<BigInteger>)weights));
        }
    }

    protected void setInitConstraints() {
        BigInteger minObjValuesBound = this.minObjValuesBound();
        for (int i = 0; i < this.initObjs.size(); ++i) {
            IntegerVariable boundVar = this.integerSolver.newIntegerVar(minObjValuesBound);
            this.objBoundVariables.add(boundVar);
            this.atLeastFlags.add((IVecInt)new VecInt());
            for (int j = 0; j < this.initObjs.size(); ++j) {
                this.addBoundConstraint(i, boundVar, j);
            }
            this.addFlagsCardinalityConstraint(i);
        }
    }

    private void addBoundConstraint(int boundVarIndex, IntegerVariable boundVar, int objIndex) {
        VecInt literals = new VecInt();
        Vec coeffs = new Vec();
        this.initObjs.get(objIndex).getVars().copyTo((IVecInt)literals);
        this.initObjs.get(objIndex).getCoeffs().copyTo((IVec)coeffs);
        int flagLit = ((IPBSolver)this.decorated()).nextFreeVarId(true);
        this.atLeastFlags.get(boundVarIndex).push(flagLit);
        literals.push(flagLit);
        coeffs.push((Object)this.minObjValuesBound().negate());
        try {
            this.integerSolver.addAtMost((IVecInt)literals, (IVec<BigInteger>)coeffs, (IVec<IntegerVariable>)new Vec().push((Object)boundVar), (IVec<BigInteger>)new Vec().push((Object)BigInteger.ONE.negate()), BigInteger.ZERO);
        }
        catch (ContradictionException e) {
            throw new RuntimeException(e);
        }
    }

    private void addFlagsCardinalityConstraint(int card) {
        try {
            ((IPBSolver)this.decorated()).addAtMost(this.atLeastFlags.get(card), card);
        }
        catch (ContradictionException e) {
            throw new RuntimeException(e);
        }
    }

    protected BigInteger minObjValuesBound() {
        BigInteger maxValue = BigInteger.ZERO;
        for (ObjectiveFunction nextObj : this.initObjs) {
            BigInteger maxObjValue = this.maxObjValue(nextObj);
            if (maxValue.compareTo(maxObjValue) >= 0) continue;
            maxValue = maxObjValue;
        }
        return maxValue.add(BigInteger.ONE);
    }

    private BigInteger maxObjValue(ObjectiveFunction obj) {
        IVec<BigInteger> objCoeffs = obj.getCoeffs();
        BigInteger coeffsSum = BigInteger.ZERO;
        Iterator objCoeffsIt = objCoeffs.iterator();
        while (objCoeffsIt.hasNext()) {
            coeffsSum = coeffsSum.add((BigInteger)objCoeffsIt.next());
        }
        return coeffsSum;
    }

    @Override
    public void addCriterion(IVecInt literals) {
        this.initObjs.add(new ObjectiveFunction(literals, (IVec<BigInteger>)new Vec(literals.size(), (Object)BigInteger.ONE)));
    }

    @Override
    public void addCriterion(IVecInt literals, IVec<BigInteger> coefs) {
        this.initObjs.add(new ObjectiveFunction(literals, coefs));
    }

    @Override
    public BigInteger[] getObjectiveValues() {
        Object[] objValues = new BigInteger[this.objs.size()];
        for (int i = 0; i < this.objs.size(); ++i) {
            objValues[i] = ((ObjectiveFunction)this.objs.get(i)).calculateDegree((RandomAccessModel)this);
        }
        Arrays.sort(objValues);
        return objValues;
    }

    @Override
    public void addObjectiveFunction(ObjectiveFunction obj) {
        this.addCriterion(obj);
    }
}

