/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.services.IDisposable;

public abstract class SaveablesProvider
implements IDisposable {
    private ISaveablesLifecycleListener listener;

    protected SaveablesProvider() {
    }

    public final void init(ISaveablesLifecycleListener listener) {
        this.listener = listener;
        this.doInit();
    }

    protected void doInit() {
    }

    protected final void fireSaveablesOpened(Saveable[] models) {
        this.listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 1, models, false));
    }

    protected final boolean fireSaveablesClosing(Saveable[] models, boolean force) {
        SaveablesLifecycleEvent saveablesLifecycleEvent = new SaveablesLifecycleEvent((Object)this, 2, models, force);
        this.listener.handleLifecycleEvent(saveablesLifecycleEvent);
        return saveablesLifecycleEvent.isVeto();
    }

    protected final void fireSaveablesClosed(Saveable[] models) {
        this.listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, models, false));
    }

    protected final void fireSaveablesDirtyChanged(Saveable[] models) {
        this.listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 4, models, false));
    }

    public abstract Saveable[] getSaveables();

    public abstract Object[] getElements(Saveable var1);

    public abstract Saveable getSaveable(Object var1);

    public void dispose() {
        this.listener = null;
    }
}

