/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StructuredViewerInternals;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;

public class StructuredViewerManager {
    private StructuredViewer viewer;
    private Object cachedOldInput;
    private Object cachedNewInput;
    private Map viewerDataMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(Object element) {
        Map map = this.viewerDataMap;
        synchronized (map) {
            return this.viewerDataMap.get(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetViewerData() {
        Map map = this.viewerDataMap;
        synchronized (map) {
            if (Policy.DEBUG_VIEWER_MAP) {
                System.out.println("viewer map RESET");
            }
            this.viewerDataMap.clear();
        }
    }

    public StructuredViewerManager(StructuredViewer aViewer, NavigatorContentService contentService) {
        this.viewer = aViewer;
        this.viewerDataMap = new HashMap();
        StructuredViewerAccess.hookAssociateListener(this.viewer, this.viewerDataMap, contentService);
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Object anOldInput, Object aNewInput) {
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = (StructuredViewer)aViewer;
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public boolean initialize(final IStructuredContentProvider aContentProvider) {
        final boolean[] result = new boolean[1];
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                if (aContentProvider != null) {
                    aContentProvider.inputChanged((Viewer)StructuredViewerManager.this.viewer, StructuredViewerManager.this.cachedOldInput, StructuredViewerManager.this.cachedNewInput);
                }
                result[0] = true;
            }
        });
        return result[0];
    }

    public void safeRefresh() {
        StructuredViewer localViewer = this.viewer;
        if (localViewer == null || localViewer.getControl().isDisposed()) {
            return;
        }
        Display display = localViewer.getControl().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(() -> this.lambda$0((Viewer)localViewer));
    }

    private /* synthetic */ void lambda$0(final Viewer viewer) {
        if (viewer.getControl().isDisposed()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                viewer.getControl().setRedraw(false);
                viewer.refresh();
            }
        });
        viewer.getControl().setRedraw(true);
    }

    static class StructuredViewerAccess
    extends StructuredViewerInternals {
        StructuredViewerAccess() {
        }

        protected static void hookAssociateListener(StructuredViewer v, Map viewerDataMap, NavigatorContentService contentService) {
            StructuredViewerInternals.setAssociateListener((StructuredViewer)v, (StructuredViewerInternals.AssociateListener)new Listener(contentService, viewerDataMap));
        }

        static class Listener
        implements StructuredViewerInternals.AssociateListener {
            private final NavigatorContentService contentService;
            private final Map viewerDataMap;

            public Listener(NavigatorContentService contentService, Map viewerDataMap) {
                this.contentService = contentService;
                this.viewerDataMap = viewerDataMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void associate(Object element, Item item) {
                NavigatorContentDescriptor desc = this.contentService.getContribution(element);
                this.contentService.forgetContribution(element);
                Map map = this.viewerDataMap;
                synchronized (map) {
                    if (this.viewerDataMap.containsKey(element)) {
                        if (Policy.DEBUG_VIEWER_MAP) {
                            System.out.println("associate: SKIPPED " + String.valueOf(element) + " item: " + String.valueOf(item) + " desc: " + String.valueOf(desc) + " FOUND");
                        }
                        return;
                    }
                    this.viewerDataMap.put(element, desc);
                    if (Policy.DEBUG_VIEWER_MAP) {
                        System.out.println("associate: " + String.valueOf(element) + " item: " + String.valueOf(item) + " desc: " + String.valueOf(desc));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void disassociate(Item item) {
                Map map = this.viewerDataMap;
                synchronized (map) {
                    if (Policy.DEBUG_VIEWER_MAP) {
                        System.out.println("disassociate:  item: " + String.valueOf(item) + " object: " + String.valueOf(item.getData()));
                    }
                    this.viewerDataMap.remove(item.getData());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void filteredOut(Object element) {
                this.contentService.forgetContribution(element);
                Map map = this.viewerDataMap;
                synchronized (map) {
                    if (Policy.DEBUG_VIEWER_MAP) {
                        System.out.println("filteredOut: object: " + String.valueOf(element));
                    }
                    this.viewerDataMap.remove(element);
                }
            }
        }
    }
}

