/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.actions.ToolBarConfigurationDescriptor;

public class ToolBarConfigurationRegistry {
    static final String EXTENSION_ID = "org.jkiss.dbeaver.toolBarConfiguration";
    private static final Log log = Log.getLog(ToolBarConfigurationRegistry.class);
    private static ToolBarConfigurationRegistry instance = null;
    private final Map<String, ToolBarConfigurationDescriptor> knownToolBars = new LinkedHashMap<String, ToolBarConfigurationDescriptor>();

    public static synchronized ToolBarConfigurationRegistry getInstance() {
        if (instance == null) {
            instance = new ToolBarConfigurationRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ToolBarConfigurationRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs = registry.getConfigurationElementsFor(EXTENSION_ID);
        Map<String, List<IConfigurationElement>> toolBarElementsByKey = Stream.of(extConfigs).filter(e -> "toolBar".equals(e.getName())).collect(Collectors.groupingBy(e -> e.getAttribute("key")));
        this.knownToolBars.clear();
        for (Map.Entry<String, List<IConfigurationElement>> entry : toolBarElementsByKey.entrySet()) {
            this.knownToolBars.put(entry.getKey(), new ToolBarConfigurationDescriptor(entry.getKey(), entry.getValue()));
        }
    }

    public Collection<ToolBarConfigurationDescriptor> getKnownToolBars() {
        return this.knownToolBars.values();
    }

    public boolean isItemVisible(@NotNull String toolBarKey, @NotNull String itemKey) {
        ToolBarConfigurationDescriptor toolBar = this.knownToolBars.get(toolBarKey);
        if (toolBar != null) {
            return toolBar.isItemVisible(itemKey);
        }
        log.error((Object)("Unknown toolbar key " + toolBarKey + " for item " + itemKey));
        return false;
    }

    static String makeItemVisibilityPreferenceKeyName(@NotNull String toolBarKey, @NotNull String itemKey, @NotNull String property) {
        return String.join((CharSequence)".", EXTENSION_ID, "toolbars", "[" + toolBarKey + "]", "items", "[" + itemKey + "]", property);
    }
}

