/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.BundleDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.ExportPackageDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private String resolution = "static";
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map<String, Object> attributes;
    private Map<String, String> arbitraryDirectives;

    ImportPackageSpecificationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            HashMap<String, Object> result = new HashMap<String, Object>(5);
            if (this.resolution != null) {
                result.put("resolution", this.resolution);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDirective(String key) {
        Object object = this.monitor;
        synchronized (object) {
            if (key.equals("resolution")) {
                return this.resolution;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object setDirective(String key, Object value) {
        Object object = this.monitor;
        synchronized (object) {
            if (key.equals("resolution")) {
                this.resolution = (String)value;
                return this.resolution;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setArbitraryDirectives(Map<String, ?> directives) {
        Object object = this.monitor;
        synchronized (object) {
            this.arbitraryDirectives = directives;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBundleSymbolicName() {
        Object object = this.monitor;
        synchronized (object) {
            block4: {
                if (!"system.bundle".equals(this.symbolicName)) break block4;
                return "org.eclipse.osgi";
            }
            return this.symbolicName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionRange getBundleVersionRange() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundleVersionRange == null) {
                return VersionRange.emptyRange;
            }
            return this.bundleVersionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription supplier) {
        return this.isSatisfiedBy(supplier, true);
    }

    public boolean isSatisfiedBy(BaseDescription supplier, boolean checkEE) {
        String[] mandatory;
        String name;
        String exporterSymbolicName;
        boolean strict;
        if (!(supplier instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescriptionImpl pkgDes = (ExportPackageDescriptionImpl)supplier;
        String[] friends = (String[])pkgDes.getDirective("x-friends");
        Boolean internal = (Boolean)pkgDes.getDirective("x-internal");
        if ((internal.booleanValue() || friends != null) && (strict = false)) {
            if (internal.booleanValue()) {
                return false;
            }
            boolean found = false;
            if (friends != null && this.getBundle().getSymbolicName() != null) {
                String[] stringArray = friends;
                int n = friends.length;
                int n2 = 0;
                while (n2 < n) {
                    String friend = stringArray[n2];
                    if (this.getBundle().getSymbolicName().equals(friend)) {
                        found = true;
                    }
                    ++n2;
                }
            }
            if (!found) {
                return false;
            }
        }
        if ((exporterSymbolicName = this.getBundleSymbolicName()) != null) {
            BundleDescription exporter = pkgDes.getExporter();
            if (!exporterSymbolicName.equals(exporter.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(exporter.getVersion())) {
                return false;
            }
        }
        if (!("*".equals(name = this.getName()) || name.endsWith(".*") && pkgDes.getName().startsWith(name.substring(0, name.length() - 1)) || pkgDes.getName().equals(name))) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(pkgDes.getVersion())) {
            return false;
        }
        Map<String, Object> importAttrs = this.getAttributes();
        if (importAttrs != null) {
            Map<String, Object> exportAttrs = pkgDes.getAttributes();
            if (exportAttrs == null) {
                return false;
            }
            for (String importKey : importAttrs.keySet()) {
                Object importValue = importAttrs.get(importKey);
                Object exportValue = exportAttrs.get(importKey);
                if (exportValue != null && importValue.equals(exportValue)) continue;
                return false;
            }
        }
        if (!this.hasMandatoryAttributes(mandatory = (String[])pkgDes.getDirective("mandatory"))) {
            return false;
        }
        if (!checkEE) {
            return true;
        }
        if (((BundleDescriptionImpl)this.getBundle()).getEquinoxEE() < 0) {
            return true;
        }
        int eeIndex = (Integer)pkgDes.getDirective("x-equinox-ee");
        return eeIndex < 0 || eeIndex == ((BundleDescriptionImpl)this.getBundle()).getEquinoxEE();
    }

    @Override
    protected boolean hasMandatoryAttributes(String[] checkMandatory) {
        if (checkMandatory != null) {
            Map<String, Object> importAttrs = this.getAttributes();
            String[] stringArray = checkMandatory;
            int n = checkMandatory.length;
            int n2 = 0;
            while (n2 < n) {
                String mandatory = stringArray[n2];
                if ("bundle-symbolic-name".equals(mandatory)) {
                    if (this.getBundleSymbolicName() == null) {
                        return false;
                    }
                } else if ("bundle-version".equals(mandatory)) {
                    if (this.bundleVersionRange == null) {
                        return false;
                    }
                } else if ("specification-version".equals(mandatory) || "version".equals(mandatory)) {
                    if (this.getVersionRange() == null) {
                        return false;
                    }
                } else {
                    if (importAttrs == null) {
                        return false;
                    }
                    if (importAttrs.get(mandatory) == null) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSymbolicName(String symbolicName) {
        Object object = this.monitor;
        synchronized (object) {
            this.symbolicName = symbolicName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleVersionRange(VersionRange bundleVersionRange) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleVersionRange = bundleVersionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAttributes(Map<String, ?> attributes) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = attributes;
        }
    }

    public String toString() {
        return "Import-Package: " + this.getName() + "; version=\"" + String.valueOf(this.getVersionRange()) + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> getInternalDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            HashMap<String, String> result = new HashMap<String, String>(5);
            if (this.arbitraryDirectives != null) {
                result.putAll(this.arbitraryDirectives);
            }
            if (this.resolution != null) {
                if ("static".equals(this.resolution)) {
                    result.put("resolution", "mandatory");
                } else {
                    result.put("resolution", this.resolution);
                }
            }
            result.put("filter", this.createFilterDirective());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFilterDirective() {
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        Object object = this.monitor;
        synchronized (object) {
            ImportPackageSpecificationImpl.addFilterAttribute(filter, "osgi.wiring.package", this.getName(), false);
            VersionRange range = this.getVersionRange();
            if (range != null && range != VersionRange.emptyRange) {
                ImportPackageSpecificationImpl.addFilterAttribute(filter, "version", range);
            }
            if (this.symbolicName != null) {
                ImportPackageSpecificationImpl.addFilterAttribute(filter, "bundle-symbolic-name", this.symbolicName);
            }
            if (this.bundleVersionRange != null) {
                ImportPackageSpecificationImpl.addFilterAttribute(filter, "bundle-version", this.bundleVersionRange);
            }
            if (this.attributes != null) {
                ImportPackageSpecificationImpl.addFilterAttributes(filter, this.attributes);
            }
        }
        filter.append(')');
        return filter.toString();
    }

    @Override
    protected Map<String, Object> getInteralAttributes() {
        return Collections.emptyMap();
    }

    @Override
    protected String getInternalNameSpace() {
        return "osgi.wiring.package";
    }
}

