export class ConsecutiveBreaker {
    /**
     * ConsecutiveBreaker breaks if more than `threshold` exceptions are received
     * over a time period.
     */
    constructor(threshold) {
        this.threshold = threshold;
        /**
         * @inheritdoc
         */
        this.state = 0;
    }
    /**
     * @inheritdoc
     */
    success() {
        this.state = 0;
    }
    /**
     * @inheritdoc
     */
    failure() {
        return ++this.state >= this.threshold;
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/e3a5acfb517a443235981655413d566533107e92/node_modules/cockatiel/dist/esm/breaker/ConsecutiveBreaker.js.map