/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.IndexedClassFinder;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.wire.WireModule;
import org.eclipse.sisu.wire.Wiring;

public final class SisuExtensions
implements SpaceModule.Strategy,
WireModule.Strategy {
    private final ClassSpace space;
    private final boolean global;

    private SisuExtensions(ClassSpace space2, boolean global) {
        this.space = space2;
        this.global = global;
    }

    public static SisuExtensions local(ClassSpace space2) {
        return new SisuExtensions(space2, false);
    }

    public static SisuExtensions global(ClassSpace space2) {
        return new SisuExtensions(space2, true);
    }

    public void install(Binder binder) {
        this.install(binder, null, null);
    }

    public <C> void install(Binder binder, Class<C> contextType, C context) {
        for (Module m : this.create(Module.class, contextType, context)) {
            binder.install(m);
        }
    }

    @Override
    public Wiring wiring(Binder binder) {
        final Wiring defaultWiring = WireModule.Strategy.DEFAULT.wiring(binder);
        final List<Wiring> customWiring = this.create(Wiring.class, Binder.class, binder);
        return customWiring.isEmpty() ? defaultWiring : new Wiring(){

            @Override
            public boolean wire(Key<?> key2) {
                for (Wiring w : customWiring) {
                    if (!w.wire(key2)) continue;
                    return true;
                }
                return defaultWiring.wire(key2);
            }
        };
    }

    @Override
    public SpaceVisitor visitor(Binder binder) {
        final SpaceVisitor defaultVisitor = SpaceModule.Strategy.DEFAULT.visitor(binder);
        final List<SpaceVisitor> customVisitors = this.create(SpaceVisitor.class, Binder.class, binder);
        return customVisitors.isEmpty() ? defaultVisitor : new SpaceVisitor(){

            @Override
            public void enterSpace(ClassSpace _space) {
                for (SpaceVisitor v : customVisitors) {
                    v.enterSpace(_space);
                }
                defaultVisitor.enterSpace(_space);
            }

            @Override
            public ClassVisitor visitClass(URL url) {
                for (SpaceVisitor v : customVisitors) {
                    ClassVisitor cv = v.visitClass(url);
                    if (cv == null) continue;
                    return cv;
                }
                return defaultVisitor.visitClass(url);
            }

            @Override
            public void leaveSpace() {
                for (SpaceVisitor v : customVisitors) {
                    v.leaveSpace();
                }
                defaultVisitor.leaveSpace();
            }
        };
    }

    public <T> List<T> create(Class<T> spi) {
        return this.create(spi, null, null);
    }

    public <T, C> List<T> create(Class<T> spi, Class<C> contextType, C context) {
        ArrayList<Object> extensions2 = new ArrayList<Object>();
        for (Class<T> impl2 : this.load(spi)) {
            try {
                Object instance = null;
                if (contextType != null) {
                    try {
                        instance = impl2.getConstructor(contextType).newInstance(context);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                extensions2.add(instance != null ? instance : (Object)impl2.newInstance());
            }
            catch (Exception e2) {
                Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
                Logs.trace("Problem creating: {}", impl2, cause);
            }
            catch (LinkageError e3) {
                Logs.trace("Problem creating: {}", impl2, e3);
            }
        }
        return extensions2;
    }

    public <T> List<Class<? extends T>> load(Class<T> spi) {
        String index2 = "META-INF/services/" + spi.getName();
        ArrayList<Class<T>> extensionTypes = new ArrayList<Class<T>>();
        for (String name2 : new IndexedClassFinder(index2, this.global).indexedNames(this.space)) {
            try {
                extensionTypes.add(this.space.loadClass(name2).asSubclass(spi));
            }
            catch (Exception e2) {
                Logs.trace("Problem loading: {}", name2, e2);
            }
            catch (LinkageError e3) {
                Logs.trace("Problem loading: {}", name2, e3);
            }
        }
        return extensionTypes;
    }
}

