/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import java.util.Map;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Group;
import net.sf.mpxj.GroupClause;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.BackgroundPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;

public abstract class GroupReader {
    protected abstract Integer getVarDataType();

    public void process(ProjectFile file, FixedData fixedData, Var2Data varData, Map<Integer, FontBase> fontBases) {
        int groupCount = fixedData.getItemCount();
        for (int groupLoop = 0; groupLoop < groupCount; ++groupLoop) {
            Integer groupID;
            byte[] groupVarData;
            byte[] groupFixedData = fixedData.getByteArrayValue(groupLoop);
            if (groupFixedData == null || groupFixedData.length < 4 || (groupVarData = varData.getByteArray(groupID = Integer.valueOf(MPPUtility.getInt(groupFixedData, 0)), this.getVarDataType())) == null) continue;
            String groupName = MPPUtility.getUnicodeString(groupFixedData, 4);
            boolean showSummaryTasks = MPPUtility.getShort(groupVarData, 4) != 0;
            Group group = new Group(groupID, groupName, showSummaryTasks);
            file.getGroups().add(group);
            int clauseCount = MPPUtility.getShort(groupVarData, 6);
            int offset = 8;
            for (int clauseIndex = 0; clauseIndex < clauseCount && offset + 47 <= groupVarData.length; ++clauseIndex) {
                GroupClause clause = new GroupClause();
                group.addGroupClause(clause);
                int fieldID = MPPUtility.getInt(groupVarData, offset);
                FieldType type = FieldTypeHelper.getInstance(fieldID);
                clause.setField(type);
                boolean ascending = MPPUtility.getByte(groupVarData, offset + 4) != 0;
                clause.setAscending(ascending);
                int fontIndex = MPPUtility.getByte(groupVarData, offset + 8);
                FontBase fontBase = fontBases.get(fontIndex);
                int style = MPPUtility.getByte(groupVarData, offset + 9);
                boolean bold = (style & 1) != 0;
                boolean italic = (style & 2) != 0;
                boolean underline = (style & 4) != 0;
                int fontColorIndex = MPPUtility.getByte(groupVarData, offset + 10);
                ColorType fontColor = ColorType.getInstance(fontColorIndex);
                FontStyle fontStyle = new FontStyle(fontBase, italic, bold, underline, false, fontColor.getColor(), null, BackgroundPattern.SOLID);
                clause.setFont(fontStyle);
                int colorIndex = MPPUtility.getByte(groupVarData, offset + 12);
                ColorType color = ColorType.getInstance(colorIndex);
                clause.setCellBackgroundColor(color.getColor());
                clause.setPattern(BackgroundPattern.getInstance(MPPUtility.getByte(groupVarData, offset + 13) & 0xF));
                int groupOn = MPPUtility.getShort(groupVarData, offset + 14);
                clause.setGroupOn(groupOn);
                Comparable<Date> startAt = null;
                Number groupInterval = null;
                switch (type.getDataType()) {
                    case DURATION: 
                    case NUMERIC: 
                    case CURRENCY: {
                        startAt = MPPUtility.getDouble(groupVarData, offset + 24);
                        groupInterval = MPPUtility.getDouble(groupVarData, offset + 40);
                        break;
                    }
                    case PERCENTAGE: {
                        startAt = MPPUtility.getInt(groupVarData, offset + 24);
                        groupInterval = MPPUtility.getInt(groupVarData, offset + 40);
                        break;
                    }
                    case BOOLEAN: {
                        startAt = MPPUtility.getShort(groupVarData, offset + 24) == 1 ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case DATE: {
                        startAt = MPPUtility.getTimestamp(groupVarData, offset + 24);
                        groupInterval = MPPUtility.getInt(groupVarData, offset + 40);
                        break;
                    }
                }
                clause.setStartAt(startAt);
                clause.setGroupInterval(groupInterval);
                offset += 48;
            }
        }
    }
}

