﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/InstanceTypeOffering.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace EC2
{
namespace Model
{
  class DescribeInstanceTypeOfferingsResponse
  {
  public:
    AWS_EC2_API DescribeInstanceTypeOfferingsResponse() = default;
    AWS_EC2_API DescribeInstanceTypeOfferingsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    AWS_EC2_API DescribeInstanceTypeOfferingsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    ///@{
    /**
     * <p>The instance types offered in the location.</p>
     */
    inline const Aws::Vector<InstanceTypeOffering>& GetInstanceTypeOfferings() const { return m_instanceTypeOfferings; }
    template<typename InstanceTypeOfferingsT = Aws::Vector<InstanceTypeOffering>>
    void SetInstanceTypeOfferings(InstanceTypeOfferingsT&& value) { m_instanceTypeOfferingsHasBeenSet = true; m_instanceTypeOfferings = std::forward<InstanceTypeOfferingsT>(value); }
    template<typename InstanceTypeOfferingsT = Aws::Vector<InstanceTypeOffering>>
    DescribeInstanceTypeOfferingsResponse& WithInstanceTypeOfferings(InstanceTypeOfferingsT&& value) { SetInstanceTypeOfferings(std::forward<InstanceTypeOfferingsT>(value)); return *this;}
    template<typename InstanceTypeOfferingsT = InstanceTypeOffering>
    DescribeInstanceTypeOfferingsResponse& AddInstanceTypeOfferings(InstanceTypeOfferingsT&& value) { m_instanceTypeOfferingsHasBeenSet = true; m_instanceTypeOfferings.emplace_back(std::forward<InstanceTypeOfferingsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token to include in another request to get the next page of items. This
     * value is <code>null</code> when there are no more items to return.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    DescribeInstanceTypeOfferingsResponse& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
    template<typename ResponseMetadataT = ResponseMetadata>
    void SetResponseMetadata(ResponseMetadataT&& value) { m_responseMetadataHasBeenSet = true; m_responseMetadata = std::forward<ResponseMetadataT>(value); }
    template<typename ResponseMetadataT = ResponseMetadata>
    DescribeInstanceTypeOfferingsResponse& WithResponseMetadata(ResponseMetadataT&& value) { SetResponseMetadata(std::forward<ResponseMetadataT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<InstanceTypeOffering> m_instanceTypeOfferings;
    bool m_instanceTypeOfferingsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    ResponseMetadata m_responseMetadata;
    bool m_responseMetadataHasBeenSet = false;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
