# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_mtree_global_optspecs
	string join \n h/help V/version
end

function __fish_alpm_mtree_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_mtree_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_mtree_using_subcommand
	set -l cmd (__fish_alpm_mtree_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-mtree -n "__fish_alpm_mtree_needs_command" -s h -l help -d 'Print help'
complete -c alpm-mtree -n "__fish_alpm_mtree_needs_command" -s V -l version -d 'Print version'
complete -c alpm-mtree -n "__fish_alpm_mtree_needs_command" -f -a "format" -d 'Read an MTREE file and return it in another file format'
complete -c alpm-mtree -n "__fish_alpm_mtree_needs_command" -f -a "validate" -d 'Validate an MTREE file'
complete -c alpm-mtree -n "__fish_alpm_mtree_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand format" -s s -l schema -d 'Provide the MTREE schema version to use' -r
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand format" -s o -l output-format -d 'Provide the output format' -r -f -a "json\t'The JSON output format'"
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand format" -s p -l pretty -d 'Determines whether the output will be displayed in a pretty non-minimized fashion'
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand validate" -s s -l schema -d 'Provide the MTREE schema version to use' -r
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand help; and not __fish_seen_subcommand_from format validate help" -f -a "format" -d 'Read an MTREE file and return it in another file format'
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand help; and not __fish_seen_subcommand_from format validate help" -f -a "validate" -d 'Validate an MTREE file'
complete -c alpm-mtree -n "__fish_alpm_mtree_using_subcommand help; and not __fish_seen_subcommand_from format validate help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
