/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalZonedDateTimePrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.temporal.DifferenceZonedDateTimeWithRoundingNode;
import com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddZonedDateTimeNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToFractionalSecondDigitsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalZonedDateTimeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.List;
import org.graalvm.shadowed.com.ibm.icu.util.Calendar;

public class TemporalZonedDateTimePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalZonedDateTimePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalZonedDateTimePrototypeBuiltins();

    protected TemporalZonedDateTimePrototypeBuiltins() {
        super(JSTemporalZonedDateTime.PROTOTYPE_NAME, TemporalZonedDateTimePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalZonedDateTimePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeCalendarGetterNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeTimeZoneIdGetterNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeGetterNodeGen.create(context, builtin, builtinEnum, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 38: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToStringNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 39: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToLocaleStringNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 40: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToLocaleStringNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 41: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 28: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 29: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithPlainTimeNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 30: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithTimeZoneNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 31: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithCalendarNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 32: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeAddSubNodeGen.create(context, builtin, 1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 33: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeAddSubNodeGen.create(context, builtin, -1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 34: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeUntilSinceNodeGen.create(context, builtin, 1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 35: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeUntilSinceNodeGen.create(context, builtin, -1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 36: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeRoundNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 37: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeEqualsNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 42: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeStartOfDayNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 43: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeGetTimeZoneTransitionNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 44: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToInstantNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 45: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainDateNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 46: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainTimeNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 47: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainDateTimeNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalZonedDateTimePrototype implements BuiltinEnum<TemporalZonedDateTimePrototype>
    {
        calendarId(0),
        timeZoneId(0),
        era(0),
        eraYear(0),
        year(0),
        month(0),
        monthCode(0),
        day(0),
        hour(0),
        minute(0),
        second(0),
        millisecond(0),
        microsecond(0),
        nanosecond(0),
        epochMilliseconds(0),
        epochNanoseconds(0),
        dayOfWeek(0),
        dayOfYear(0),
        weekOfYear(0),
        yearOfWeek(0),
        hoursInDay(0),
        daysInWeek(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        offsetNanoseconds(0),
        offset(0),
        with(1),
        withPlainTime(0),
        withTimeZone(1),
        withCalendar(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        startOfDay(0),
        getTimeZoneTransition(1),
        toInstant(0),
        toPlainDate(0),
        toPlainTime(0),
        toPlainDateTime(0);

        private final int length;

        private TemporalZonedDateTimePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.range(calendarId, offset).contains(this);
        }
    }

    public static abstract class JSTemporalZonedDateTimeCalendarGetterNode
    extends JSBuiltinNode {
        protected JSTemporalZonedDateTimeCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString calendarId(JSTemporalZonedDateTimeObject zonedDateTime, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(zonedDateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(zonedDateTime)"})
        static TruffleString invalidReceiver(Object zonedDateTime) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeTimeZoneIdGetterNode
    extends JSBuiltinNode {
        protected JSTemporalZonedDateTimeTimeZoneIdGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString timeZoneId(JSTemporalZonedDateTimeObject zonedDateTime, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier) {
            return toTimeZoneIdentifier.execute(zonedDateTime.getTimeZone());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(zonedDateTime)"})
        static TruffleString invalidReceiver(Object zonedDateTime) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeGetterNode
    extends JSBuiltinNode {
        protected final TemporalZonedDateTimePrototype property;

        protected JSTemporalZonedDateTimeGetterNode(JSContext context, JSBuiltin builtin, TemporalZonedDateTimePrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object zonedDateTimeGetter(JSTemporalZonedDateTimeObject zdt, @Cached TruffleString.EqualNode equalNode, @Cached InlinedConditionProfile isoCalendarProfile, @Cached InlinedBranchProfile errorBranch) {
            switch (this.property.ordinal()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return this.getterCalendarDetails(zdt, equalNode, isoCalendarProfile);
                }
                case 20: {
                    return this.getterHoursInDay(zdt, errorBranch);
                }
                case 14: {
                    return TemporalUtil.nanosToMillis(zdt.getNanoseconds());
                }
                case 15: {
                    return zdt.getNanoseconds();
                }
                case 26: {
                    return JSTemporalZonedDateTimeGetterNode.getterOffsetNanoseconds(zdt);
                }
                case 27: {
                    return this.getterOffset(zdt);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        private Object getterOffset(JSTemporalZonedDateTimeObject zdt) {
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            TruffleString timeZone = zdt.getTimeZone();
            return TemporalUtil.builtinTimeZoneGetOffsetStringFor(timeZone, instant);
        }

        private static double getterOffsetNanoseconds(JSTemporalZonedDateTimeObject zdt) {
            return TemporalUtil.getOffsetNanosecondsFor(zdt.getTimeZone(), zdt.getNanoseconds());
        }

        private Object getterHoursInDay(JSTemporalZonedDateTimeObject zdt, InlinedBranchProfile errorBranch) {
            TruffleString timeZone = zdt.getTimeZone();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            TruffleString isoCalendar = TemporalConstants.ISO8601;
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, isoCalendar);
            int year = temporalDateTime.getYear();
            int month = temporalDateTime.getMonth();
            int day = temporalDateTime.getDay();
            JSTemporalPlainDateTimeObject today = JSTemporalPlainDateTime.create(this.getContext(), realm, year, month, day, 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            ISODateRecord tomorrowFields = TemporalUtil.addISODate(year, month, day, 0, 0, 0, 1, TemporalUtil.Overflow.REJECT);
            JSTemporalPlainDateTimeObject tomorrow = JSTemporalPlainDateTime.create(this.getContext(), realm, tomorrowFields.year(), tomorrowFields.month(), tomorrowFields.day(), 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            BigInt todayNs = TemporalUtil.getEpochNanosecondsFor(this.getContext(), realm, timeZone, today, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt tomorrowNs = TemporalUtil.getEpochNanosecondsFor(this.getContext(), realm, timeZone, tomorrow, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt diffNs = tomorrowNs.subtract(todayNs);
            return diffNs.divide(TemporalUtil.BI_NS_PER_HOUR).doubleValue();
        }

        private Object getterCalendarDetails(JSTemporalZonedDateTimeObject zdt, TruffleString.EqualNode equalNode, InlinedConditionProfile isoCalendarProfile) {
            TruffleString timeZone = zdt.getTimeZone();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            TruffleString calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject tdt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, calendar);
            boolean isoCalendar = isoCalendarProfile.profile((Node)this, Strings.equals(equalNode, TemporalConstants.ISO8601, calendar));
            Calendar cal = null;
            if (!isoCalendar) {
                cal = IntlUtil.getCalendar(calendar, tdt.getYear(), tdt.getMonth(), tdt.getDay());
            }
            switch (this.property.ordinal()) {
                case 2: {
                    return isoCalendar ? Undefined.instance : IntlUtil.getEra(cal);
                }
                case 3: {
                    return isoCalendar ? Undefined.instance : IntlUtil.getEraYear(cal);
                }
                case 4: {
                    return isoCalendar ? tdt.getYear() : IntlUtil.getCalendarField(cal, 19);
                }
                case 5: {
                    return isoCalendar ? tdt.getMonth() : IntlUtil.getCalendarField(cal, 23) + 1;
                }
                case 6: {
                    return isoCalendar ? TemporalUtil.buildISOMonthCode(tdt.getMonth()) : Strings.fromJavaString(IntlUtil.getTemporalMonthCode(cal));
                }
                case 7: {
                    return isoCalendar ? tdt.getDay() : IntlUtil.getCalendarField(cal, 5);
                }
                case 8: {
                    return tdt.getHour();
                }
                case 9: {
                    return tdt.getMinute();
                }
                case 10: {
                    return tdt.getSecond();
                }
                case 11: {
                    return tdt.getMillisecond();
                }
                case 12: {
                    return tdt.getMicrosecond();
                }
                case 13: {
                    return tdt.getNanosecond();
                }
                case 16: {
                    return isoCalendar ? TemporalUtil.toISODayOfWeek(tdt.getYear(), tdt.getMonth(), tdt.getDay()) : (long)IntlUtil.getCalendarField(cal, 7);
                }
                case 17: {
                    return isoCalendar ? TemporalUtil.toISODayOfYear(tdt.getYear(), tdt.getMonth(), tdt.getDay()) : IntlUtil.getCalendarField(cal, 6);
                }
                case 18: {
                    return isoCalendar ? Long.valueOf(TemporalUtil.weekOfToISOWeekOfYear(tdt.getYear(), tdt.getMonth(), tdt.getDay())) : Undefined.instance;
                }
                case 19: {
                    return isoCalendar ? Long.valueOf(TemporalUtil.yearOfToISOWeekOfYear(tdt.getYear(), tdt.getMonth(), tdt.getDay())) : Undefined.instance;
                }
                case 21: {
                    return isoCalendar ? 7 : IntlUtil.getCalendarFieldMax(cal, 7);
                }
                case 22: {
                    return isoCalendar ? TemporalUtil.isoDaysInMonth(tdt.getYear(), tdt.getMonth()) : IntlUtil.getCalendarFieldMax(cal, 5);
                }
                case 23: {
                    return isoCalendar ? TemporalUtil.isoDaysInYear(tdt.getYear()) : IntlUtil.getCalendarFieldMax(cal, 6);
                }
                case 24: {
                    return isoCalendar ? 12 : IntlUtil.getCalendarFieldMax(cal, 23) + 1;
                }
                case 25: {
                    return isoCalendar ? JSDate.isLeapYear(tdt.getYear()) : IntlUtil.isLeapYear(cal);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalZonedDateTimeObject zonedDateTime, Object optionsParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToFractionalSecondDigitsNode toFractionalSecondDigitsNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            int digits = toFractionalSecondDigitsNode.execute((Object)options);
            TruffleString showOffset = TemporalUtil.toShowOffsetOption(options, getOptionNode);
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(options, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.HOUR) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
            }
            TruffleString showTimeZone = TemporalUtil.toShowTimeZoneNameOption(options, getOptionNode);
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecisionRecord(smallestUnit, digits);
            return TemporalUtil.temporalZonedDateTimeToString(this.getContext(), this.getRealm(), zonedDateTime, precision.getPrecision(), showCalendar, showTimeZone, showOffset, precision.getIncrement(), precision.getUnit(), roundingMode);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalZonedDateTimeObject zonedDateTime) {
            return TemporalUtil.temporalZonedDateTimeToString(this.getContext(), this.getRealm(), zonedDateTime, TemporalConstants.AUTO, TemporalUtil.ShowCalendar.AUTO, TemporalConstants.AUTO, TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    @ImportStatic(value={TemporalConstants.class})
    public static abstract class JSTemporalZonedDateTimeWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWith(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object with(JSTemporalZonedDateTimeObject zonedDateTime, Object temporalZonedDateTimeLike, Object options, @Bind Node node, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TruffleString.EqualNode equalNode, @Cached(value="create(getContext(), HOUR)") CreateDataPropertyNode createHourDataPropertyNode, @Cached(value="create(getContext(), MINUTE)") CreateDataPropertyNode createMinuteDataPropertyNode, @Cached(value="create(getContext(), SECOND)") CreateDataPropertyNode createSecondDataPropertyNode, @Cached(value="create(getContext(), MILLISECOND)") CreateDataPropertyNode createMillisecondDataPropertyNode, @Cached(value="create(getContext(), MICROSECOND)") CreateDataPropertyNode createMicrosecondDataPropertyNode, @Cached(value="create(getContext(), NANOSECOND)") CreateDataPropertyNode createNanosecondDataPropertyNode, @Cached(value="create(getContext(), OFFSET)") CreateDataPropertyNode createOffsetDataPropertyNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!isPartialTemporalObjectNode.execute(temporalZonedDateTimeLike)) {
                errorBranch.enter(node);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            BigInt epochNs = zonedDateTime.getNanoseconds();
            TruffleString timeZone = zonedDateTime.getTimeZone();
            TruffleString calendar = zonedDateTime.getCalendar();
            long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZone, epochNs);
            JSContext ctx = this.getContext();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject isoDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, instant, calendar, offsetNanoseconds);
            JSDynamicObject fields = TemporalUtil.isoDateToFields(ctx, calendar, isoDateTime.isoDate(), TemporalUtil.FieldsType.DATE);
            createHourDataPropertyNode.executeVoid((Object)fields, isoDateTime.getHour());
            createMinuteDataPropertyNode.executeVoid((Object)fields, isoDateTime.getMinute());
            createSecondDataPropertyNode.executeVoid((Object)fields, isoDateTime.getSecond());
            createMillisecondDataPropertyNode.executeVoid((Object)fields, isoDateTime.getMillisecond());
            createMicrosecondDataPropertyNode.executeVoid((Object)fields, isoDateTime.getMicrosecond());
            createNanosecondDataPropertyNode.executeVoid((Object)fields, isoDateTime.getNanosecond());
            createOffsetDataPropertyNode.executeVoid((Object)fields, TemporalUtil.formatISOTimeZoneOffsetString(offsetNanoseconds));
            JSObject partialZonedDateTime = TemporalUtil.prepareCalendarFields(ctx, calendar, temporalZonedDateTimeLike, TemporalUtil.listDMMCY, TemporalUtil.listTimeUnitsOffset, null);
            fields = TemporalUtil.calendarMergeFields(ctx, calendar, fields, partialZonedDateTime);
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, node, errorBranch, optionUndefined);
            TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation((Object)resolvedOptions, getOptionNode, equalNode);
            TemporalUtil.OffsetOption offset = TemporalUtil.toTemporalOffset((Object)resolvedOptions, TemporalConstants.PREFER, getOptionNode, equalNode);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption((Object)resolvedOptions, getOptionNode);
            JSTemporalDateTimeRecord dateTimeResult = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, overflow, dateFromFieldsNode);
            Object offsetString = JSObject.get(fields, TemporalConstants.OFFSET);
            long newOffsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString((TruffleString)offsetString);
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, dateTimeResult.getYear(), dateTimeResult.getMonth(), dateTimeResult.getDay(), dateTimeResult.getHour(), dateTimeResult.getMinute(), dateTimeResult.getSecond(), dateTimeResult.getMillisecond(), dateTimeResult.getMicrosecond(), dateTimeResult.getNanosecond(), TemporalUtil.OffsetBehaviour.OPTION, newOffsetNanoseconds, timeZone, disambiguation, offset, TemporalUtil.MatchBehaviour.MATCH_EXACTLY);
            return JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object temporalZonedDateTimeLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithPlainTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithPlainTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withPlainTime(JSTemporalZonedDateTimeObject zonedDateTime, Object plainTimeLike, @Cached ToTemporalTimeNode toTemporalTime, @Cached InlinedBranchProfile errorBranch) {
            JSRealm realm = this.getRealm();
            JSTemporalPlainTimeObject plainTime = plainTimeLike == Undefined.instance ? JSTemporalPlainTime.create(this.getContext(), realm, 0, 0, 0, 0, 0, 0, this, errorBranch) : toTemporalTime.execute(plainTimeLike, (Object)Undefined.instance);
            TruffleString timeZone = zonedDateTime.getTimeZone();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            TruffleString calendar = zonedDateTime.getCalendar();
            JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, calendar);
            JSTemporalPlainDateTimeObject resultPlainDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, plainDateTime.getYear(), plainDateTime.getMonth(), plainDateTime.getDay(), plainTime.getHour(), plainTime.getMinute(), plainTime.getSecond(), plainTime.getMillisecond(), plainTime.getMicrosecond(), plainTime.getNanosecond(), calendar, this, errorBranch);
            BigInt epochNs = TemporalUtil.getEpochNanosecondsFor(this.getContext(), realm, timeZone, resultPlainDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNs, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object plainTimeLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithTimeZone
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithTimeZone(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withTimeZone(JSTemporalZonedDateTimeObject zonedDateTime, Object timeZoneLike, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier) {
            TruffleString timeZone = toTimeZoneIdentifier.execute(timeZoneLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds(), timeZone, zonedDateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object timeZoneLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithCalendar
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithCalendar(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withCalendar(JSTemporalZonedDateTimeObject zonedDateTime, Object calendarLike, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            TruffleString calendar = toCalendarIdentifier.executeString(calendarLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds(), zonedDateTime.getTimeZone(), calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object calendarLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalZonedDateTimeAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject addDurationToOrSubtractDurationFromZonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, Object temporalDurationLike, Object optionsParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached TemporalAddZonedDateTimeNode addZonedDateTimeNode) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TruffleString timeZone = zonedDateTime.getTimeZone();
            TruffleString calendar = zonedDateTime.getCalendar();
            JSRealm realm = this.getRealm();
            BigInt norm = TemporalUtil.normalizeTimeDuration((double)this.sign * duration.getHours(), (double)this.sign * duration.getMinutes(), (double)this.sign * duration.getSeconds(), (double)this.sign * duration.getMilliseconds(), (double)this.sign * duration.getMicroseconds(), (double)this.sign * duration.getNanoseconds());
            BigInt epochNanoseconds = addZonedDateTimeNode.execute(zonedDateTime.getNanoseconds(), timeZone, calendar, (double)this.sign * duration.getYears(), (double)this.sign * duration.getMonths(), (double)this.sign * duration.getWeeks(), (double)this.sign * duration.getDays(), norm, null, options);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object temporalDurationLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalZonedDateTimeUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected Object differenceTemporalZonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, Object otherParam, Object options, @Bind Node node, @Cached ToTemporalZonedDateTimeNode toTemporalZonedDateTime, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached DifferenceZonedDateTimeWithRoundingNode differenceZonedDateTimeWithRounding, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalZonedDateTimeObject other = toTemporalZonedDateTime.execute(otherParam, (Object)Undefined.instance);
            TruffleString calendar = zonedDateTime.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toCalendarIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, node, errorBranch, optionUndefined);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingDateTimeOrAuto, TemporalUtil.unitMappingDateTime, TemporalUtil.Unit.NANOSECOND, TemporalUtil.Unit.HOUR);
            TemporalUtil.Unit largestUnit = settings.largestUnit();
            JSRealm realm = this.getRealm();
            if (TemporalUtil.Unit.YEAR != largestUnit && TemporalUtil.Unit.MONTH != largestUnit && TemporalUtil.Unit.WEEK != largestUnit && TemporalUtil.Unit.DAY != largestUnit) {
                TemporalUtil.NormalizedTimeDurationWithTotalRecord diffRecord = TemporalUtil.differenceInstant(zonedDateTime.getNanoseconds(), other.getNanoseconds(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
                BigInt norm = diffRecord.normalizedTimeDuration();
                TimeDurationRecord result = TemporalUtil.balanceTimeDuration(norm, largestUnit);
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, (double)this.sign * result.hours(), (double)this.sign * result.minutes(), (double)this.sign * result.seconds(), (double)this.sign * result.milliseconds(), (double)this.sign * result.microseconds(), (double)this.sign * result.nanoseconds(), node, errorBranch);
            }
            TruffleString timeZone = zonedDateTime.getTimeZone();
            if (!TemporalUtil.timeZoneEquals(timeZone, other.getTimeZone(), toTimeZoneIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalTimeZoneExpected();
            }
            if (zonedDateTime.getNanoseconds().compareTo(other.getNanoseconds()) == 0) {
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
            }
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, calendar);
            TemporalDurationWithTotalRecord resultRecord = differenceZonedDateTimeWithRounding.execute(zonedDateTime.getNanoseconds(), other.getNanoseconds(), calendar, timeZone, precalculatedPlainDateTime, largestUnit, settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
            JSTemporalDurationRecord result = resultRecord.duration();
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, (double)this.sign * result.getYears(), (double)this.sign * result.getMonths(), (double)this.sign * result.getWeeks(), (double)this.sign * result.getDays(), (double)this.sign * result.getHours(), (double)this.sign * result.getMinutes(), (double)this.sign * result.getSeconds(), (double)this.sign * result.getMilliseconds(), (double)this.sign * result.getMicroseconds(), (double)this.sign * result.getNanoseconds(), node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object otherParam, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject round(JSTemporalZonedDateTimeObject zonedDateTime, Object roundToParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            boolean inclusive;
            int maximum;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, roundToParam);
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            int roundingIncrement = getRoundingIncrementOption.execute((Object)roundTo);
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(roundTo, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTimeOrDay, TemporalUtil.Unit.REQUIRED);
            if (TemporalUtil.Unit.DAY == smallestUnit) {
                maximum = 1;
                inclusive = true;
            } else {
                maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
                inclusive = false;
            }
            TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum, inclusive, this, errorBranch);
            JSRealm realm = this.getRealm();
            BigInt thisNs = zonedDateTime.getNanoseconds();
            TruffleString timeZone = zonedDateTime.getTimeZone();
            TruffleString calendar = zonedDateTime.getCalendar();
            if (smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1) {
                return JSTemporalZonedDateTime.create(this.getContext(), realm, thisNs, timeZone, calendar);
            }
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, thisNs);
            long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZone, thisNs);
            JSTemporalPlainDateTimeObject tdt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, instant, calendar, offsetNanoseconds);
            TruffleString isoCalendar = TemporalConstants.ISO8601;
            JSTemporalPlainDateTimeObject dtStart = JSTemporalPlainDateTime.create(this.getContext(), realm, tdt.getYear(), tdt.getMonth(), tdt.getDay(), 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            BigInt startNs = TemporalUtil.getEpochNanosecondsFor(this.getContext(), realm, timeZone, dtStart, TemporalUtil.Disambiguation.COMPATIBLE);
            JSTemporalInstantObject instantStart = JSTemporalInstant.create(this.getContext(), realm, startNs);
            BigInt endNs = TemporalUtil.addDaysToZonedDateTime(this.getContext(), realm, instantStart, dtStart, timeZone, 1).epochNanoseconds();
            BigInt dayLengthNs = endNs.subtract(startNs);
            if (dayLengthNs.compareValueTo(0L) == 0) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("day length of zero now allowed");
            }
            JSTemporalDurationRecord roundResult = TemporalUtil.roundISODateTime(tdt.getYear(), tdt.getMonth(), tdt.getDay(), tdt.getHour(), tdt.getMinute(), tdt.getSecond(), tdt.getMillisecond(), tdt.getMicrosecond(), tdt.getNanosecond(), roundingIncrement, smallestUnit, roundingMode);
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(this.getContext(), realm, TemporalUtil.dtoi(roundResult.getYears()), TemporalUtil.dtoi(roundResult.getMonths()), TemporalUtil.dtoi(roundResult.getDays()), TemporalUtil.dtoi(roundResult.getHours()), TemporalUtil.dtoi(roundResult.getMinutes()), TemporalUtil.dtoi(roundResult.getSeconds()), TemporalUtil.dtoi(roundResult.getMilliseconds()), TemporalUtil.dtoi(roundResult.getMicroseconds()), TemporalUtil.dtoi(roundResult.getNanoseconds()), TemporalUtil.OffsetBehaviour.OPTION, offsetNanoseconds, timeZone, TemporalUtil.Disambiguation.COMPATIBLE, TemporalUtil.OffsetOption.PREFER, TemporalUtil.MatchBehaviour.MATCH_EXACTLY);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalZonedDateTimeObject thisZonedDateTime, Object otherParam, @Cached ToTemporalZonedDateTimeNode toTemporalZonedDateTime, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            JSTemporalZonedDateTimeObject otherZonedDateTime = toTemporalZonedDateTime.execute(otherParam, (Object)Undefined.instance);
            if (!thisZonedDateTime.getNanoseconds().equals(otherZonedDateTime.getNanoseconds())) {
                return false;
            }
            if (!TemporalUtil.timeZoneEquals(thisZonedDateTime.getTimeZone(), otherZonedDateTime.getTimeZone(), toTimeZoneIdentifier)) {
                return false;
            }
            return TemporalUtil.calendarEquals(thisZonedDateTime.getCalendar(), otherZonedDateTime.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static boolean invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeStartOfDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeStartOfDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object startOfDay(JSTemporalZonedDateTimeObject zonedDateTime, @Cached InlinedBranchProfile errorBranch) {
            TruffleString timeZone = zonedDateTime.getTimeZone();
            TruffleString calendar = zonedDateTime.getCalendar();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, calendar);
            JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, dt.getYear(), dt.getMonth(), dt.getDay(), 0, 0, 0, 0, 0, 0, calendar, this, errorBranch);
            BigInt startNs = TemporalUtil.getEpochNanosecondsFor(this.getContext(), realm, timeZone, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, startNs, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    @ImportStatic(value={IntlUtil.class})
    public static abstract class JSTemporalZonedDateTimeGetTimeZoneTransition
    extends JSTemporalBuiltinOperation {
        private static final List<String> DIRECTION_OPTION_VALUES = List.of("next", "previous");

        protected JSTemporalZonedDateTimeGetTimeZoneTransition(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getTimeZoneTransition(JSTemporalZonedDateTimeObject zonedDateTime, Object param, @Bind Node node, @Cached(value="create(getContext(), KEY_DIRECTION)") CreateDataPropertyNode createDirectionProperty, @Cached(value="create(getContext())") GetOptionsObjectNode getOptionsObject, @Cached(value="createDirectionGetter()") GetStringOptionNode getDirection, @Cached InlinedBranchProfile errorBranch) {
            BigInt transition;
            Object directionParam = param;
            TruffleString timeZone = zonedDateTime.getTimeZone();
            if (directionParam == Undefined.instance) {
                errorBranch.enter(node);
                throw Errors.createTypeError("Direction not specified");
            }
            if (directionParam instanceof TruffleString) {
                TruffleString paramString = (TruffleString)directionParam;
                directionParam = JSOrdinary.createWithNullPrototype(this.getContext());
                createDirectionProperty.executeVoid(directionParam, paramString);
            } else {
                directionParam = getOptionsObject.execute(directionParam);
            }
            String direction = getDirection.executeValue(directionParam);
            if (direction == null) {
                errorBranch.enter(node);
                throw Errors.createRangeError("Invalid direction");
            }
            if (TemporalUtil.canParseAsTimeZoneNumericUTCOffset(timeZone)) {
                return Null.instance;
            }
            if ("next".equals(direction)) {
                transition = TemporalUtil.getIANATimeZoneNextTransition(timeZone, zonedDateTime.getNanoseconds());
            } else {
                assert ("previous".equals(direction));
                transition = TemporalUtil.getIANATimeZonePreviousTransition(timeZone, zonedDateTime.getNanoseconds());
            }
            if (transition == null) {
                return Null.instance;
            }
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), transition, timeZone, zonedDateTime.getCalendar());
        }

        @NeverDefault
        protected GetStringOptionNode createDirectionGetter() {
            return GetStringOptionNode.create(this.getContext(), IntlUtil.KEY_DIRECTION, DIRECTION_OPTION_VALUES, null);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object directionParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToInstant
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToInstant(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toInstant(JSTemporalZonedDateTimeObject zonedDateTime) {
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainDate
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainDate(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainDate(JSTemporalZonedDateTimeObject zdt, @Cached InlinedBranchProfile errorBranch) {
            TruffleString timeZone = zdt.getTimeZone();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), this.getRealm(), zdt.getNanoseconds());
            TruffleString calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), this.getRealm(), timeZone, instant, calendar);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dt.getYear(), dt.getMonth(), dt.getDay(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainTime(JSTemporalZonedDateTimeObject zdt, @Cached InlinedBranchProfile errorBranch) {
            TruffleString timeZone = zdt.getTimeZone();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            TruffleString calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, calendar);
            return JSTemporalPlainTime.create(this.getContext(), realm, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainDateTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainDateTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainDateTime(JSTemporalZonedDateTimeObject zdt) {
            TruffleString timeZone = zdt.getTimeZone();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            TruffleString calendar = zdt.getCalendar();
            return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZone, instant, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }
}

