/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaObjectImpl;
import oracle.jdbc.driver.json.tree.JsonpObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonObjectImpl
implements OracleJsonObject {
    final Map<String, OracleJsonValue> map;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    public OracleJsonObjectImpl() {
        this.map = new LinkedHashMap<String, OracleJsonValue>();
    }

    public OracleJsonObjectImpl(OracleJsonObject other) {
        this.map = new HashMap<String, OracleJsonValue>();
        block4: for (Map.Entry e2 : other.entrySet()) {
            String key = (String)e2.getKey();
            OracleJsonValue value = (OracleJsonValue)e2.getValue();
            switch (value.getOracleJsonType()) {
                case OBJECT: {
                    this.map.put(key, new OracleJsonObjectImpl(value.asJsonObject()));
                    continue block4;
                }
                case ARRAY: {
                    this.map.put(key, new OracleJsonArrayImpl(value.asJsonArray()));
                    continue block4;
                }
            }
            this.map.put(key, value);
        }
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.OBJECT;
    }

    private void checkNull(OracleJsonValue v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public OracleJsonValue get(Object key) {
        return this.map.get(key);
    }

    @Override
    public OracleJsonValue put(String key, OracleJsonValue value) {
        this.checkNull(value);
        return this.map.put(key, value);
    }

    @Override
    public OracleJsonValue remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends OracleJsonValue> m2) {
        for (Map.Entry<? extends String, ? extends OracleJsonValue> e2 : m2.entrySet()) {
            this.checkNull(e2.getValue());
            this.map.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<OracleJsonValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, OracleJsonValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String getString(String name) {
        return this.map.get(name).asJsonString().getString();
    }

    @Override
    public String getString(String name, String defaultValue) {
        OracleJsonValue v2 = this.map.get(name);
        return v2 == null || v2.getOracleJsonType() != OracleJsonValue.OracleJsonType.STRING ? defaultValue : v2.asJsonString().getString();
    }

    @Override
    public int getInt(String name) {
        return ((OracleJsonNumber)this.map.get(name)).intValue();
    }

    @Override
    public int getInt(String name, int defaultValue) {
        OracleJsonValue v2 = this.map.get(name);
        return v2 instanceof OracleJsonNumber ? ((OracleJsonNumber)v2).intValue() : defaultValue;
    }

    @Override
    public double getDouble(String name) {
        return ((OracleJsonNumber)this.map.get(name)).doubleValue();
    }

    @Override
    public long getLong(String key) {
        return ((OracleJsonNumber)this.map.get(key)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return ((OracleJsonNumber)this.map.get(key)).bigDecimalValue();
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        OracleJsonValue v2 = this.map.get(name);
        return v2 instanceof OracleJsonNumber ? ((OracleJsonNumber)v2).doubleValue() : defaultValue;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        OracleJsonValue v2 = this.map.get(key);
        return v2 instanceof OracleJsonNumber ? ((OracleJsonNumber)v2).longValue() : defaultValue;
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        OracleJsonValue v2 = this.map.get(key);
        return v2 instanceof OracleJsonNumber ? ((OracleJsonNumber)v2).bigDecimalValue() : defaultValue;
    }

    @Override
    public boolean getBoolean(String name) {
        OracleJsonValue v2 = this.map.get(name);
        if (v2.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (v2.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        OracleJsonValue v2 = this.map.get(name);
        if (v2 == null) {
            return defaultValue;
        }
        if (v2.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (v2.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean isNull(String name) {
        return this.map.get(name).equals(OracleJsonValue.NULL);
    }

    @Override
    public LocalDateTime getLocalDateTime(String key) {
        OracleJsonValue v2 = this.map.get(key);
        if (v2.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return v2.asJsonDate().getLocalDateTime();
        }
        return v2.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key) {
        OracleJsonValue v2 = this.map.get(key);
        return v2.asJsonTimestampTZ().getOffsetDateTime();
    }

    @Override
    public LocalDateTime getLocalDateTime(String key, LocalDateTime defaultValue) {
        OracleJsonValue v2 = this.map.get(key);
        if (v2 == null) {
            return defaultValue;
        }
        if (v2.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return v2.asJsonDate().getLocalDateTime();
        }
        if (v2.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return v2.asJsonTimestamp().getLocalDateTime();
        }
        return defaultValue;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key, OffsetDateTime defaultValue) {
        OracleJsonValue v2 = this.map.get(key);
        if (v2 == null) {
            return defaultValue;
        }
        if (v2.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return v2.asJsonTimestampTZ().getOffsetDateTime();
        }
        return defaultValue;
    }

    @Override
    public byte[] getBytes(String name) {
        return this.get(name).asJsonBinary().getBytes();
    }

    @Override
    public byte[] getBytes(String name, byte[] defaultValue) {
        OracleJsonValue v2 = this.map.get(name);
        if (v2 == null) {
            return defaultValue;
        }
        if (v2.getOracleJsonType() == OracleJsonValue.OracleJsonType.BINARY) {
            return v2.asJsonBinary().getBytes();
        }
        return defaultValue;
    }

    @Override
    public OracleJsonValue put(String name, byte[] value) {
        return this.map.put(name, new OracleJsonBinaryImpl(value, false));
    }

    @Override
    public OracleJsonValue put(String name, String value) {
        return this.put(name, new OracleJsonStringImpl(value));
    }

    @Override
    public OracleJsonValue put(String name, int value) {
        return this.put(name, new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.INT));
    }

    @Override
    public OracleJsonValue put(String name, long value) {
        return this.put(name, new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.LONG));
    }

    @Override
    public OracleJsonValue put(String name, BigDecimal value) {
        return this.put(name, new OracleJsonDecimalImpl(value));
    }

    @Override
    public OracleJsonValue put(String name, double value) {
        return this.put(name, new OracleJsonDoubleImpl(value));
    }

    @Override
    public OracleJsonValue put(String name, boolean value) {
        return this.put(name, value ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public OracleJsonValue putNull(String name) {
        return this.put(name, OracleJsonValue.NULL);
    }

    @Override
    public OracleJsonValue put(String key, OffsetDateTime value) {
        return this.put(key, new OracleJsonTimestampTZImpl(value));
    }

    @Override
    public OracleJsonValue put(String key, LocalDateTime value) {
        return this.put(key, new OracleJsonTimestampImpl(value));
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        JsonSerializerImpl ser = new JsonSerializerImpl(writer);
        ser.write(this);
        ser.close();
        return writer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.map.equals(other);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public <T> T wrap(Class<T> c2) {
        if (Jsonp.isJakartaJson(c2)) {
            return c2.cast(new JakartaObjectImpl(this));
        }
        return c2.cast(new JsonpObjectImpl(this));
    }

    static {
        try {
            $$$methodRef$$$51 = OracleJsonObjectImpl.class.getDeclaredConstructor(OracleJsonObject.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleJsonObjectImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleJsonObjectImpl.class.getDeclaredMethod("get", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleJsonObjectImpl.class.getDeclaredMethod("put", Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleJsonObjectImpl.class.getDeclaredMethod("remove", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleJsonObjectImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleJsonObjectImpl.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleJsonObjectImpl.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleJsonObjectImpl.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleJsonObjectImpl.class.getDeclaredMethod("putNull", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleJsonObjectImpl.class.getDeclaredMethod("getBytes", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleJsonObjectImpl.class.getDeclaredMethod("getBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleJsonObjectImpl.class.getDeclaredMethod("getOffsetDateTime", String.class, OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleJsonObjectImpl.class.getDeclaredMethod("getLocalDateTime", String.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleJsonObjectImpl.class.getDeclaredMethod("getOffsetDateTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleJsonObjectImpl.class.getDeclaredMethod("getLocalDateTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleJsonObjectImpl.class.getDeclaredMethod("isNull", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleJsonObjectImpl.class.getDeclaredMethod("getBoolean", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleJsonObjectImpl.class.getDeclaredMethod("getBoolean", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleJsonObjectImpl.class.getDeclaredMethod("getBigDecimal", String.class, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleJsonObjectImpl.class.getDeclaredMethod("getLong", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleJsonObjectImpl.class.getDeclaredMethod("getDouble", String.class, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleJsonObjectImpl.class.getDeclaredMethod("getBigDecimal", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleJsonObjectImpl.class.getDeclaredMethod("getLong", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleJsonObjectImpl.class.getDeclaredMethod("getDouble", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleJsonObjectImpl.class.getDeclaredMethod("getInt", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleJsonObjectImpl.class.getDeclaredMethod("getInt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleJsonObjectImpl.class.getDeclaredMethod("getString", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleJsonObjectImpl.class.getDeclaredMethod("getString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleJsonObjectImpl.class.getDeclaredMethod("entrySet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleJsonObjectImpl.class.getDeclaredMethod("values", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleJsonObjectImpl.class.getDeclaredMethod("keySet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJsonObjectImpl.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJsonObjectImpl.class.getDeclaredMethod("putAll", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJsonObjectImpl.class.getDeclaredMethod("remove", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonObjectImpl.class.getDeclaredMethod("put", String.class, OracleJsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonObjectImpl.class.getDeclaredMethod("get", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonObjectImpl.class.getDeclaredMethod("containsValue", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonObjectImpl.class.getDeclaredMethod("containsKey", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonObjectImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonObjectImpl.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonObjectImpl.class.getDeclaredMethod("checkNull", OracleJsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonObjectImpl.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

