/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.BinaryDoubleCopyingBinder;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class BinaryDoubleBinder
extends Binder {
    double paramVal;
    Binder theBinaryDoubleCopyingBinder = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    static void init(Binder x2) {
        x2.type = (short)101;
        x2.bytelen = 8;
    }

    BinaryDoubleBinder(double x2) {
        BinaryDoubleBinder.init(this);
        this.paramVal = x2;
    }

    @Override
    Binder copyingBinder() {
        if (this.theBinaryDoubleCopyingBinder == null) {
            this.theBinaryDoubleCopyingBinder = new BinaryDoubleCopyingBinder(this.paramVal);
        }
        return this.theBinaryDoubleCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        int offset;
        byte[] b2 = null;
        int fixedLength = 8;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b2 = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b2 = bindBytes;
            offset = byteoffset;
        }
        double val = this.paramVal;
        fixedLength = this.getDatumBytes(stmt, val, b2, offset);
        if (bindUseDBA) {
            bindData.put(b2, 0, fixedLength);
            bindDataLengths[bindDataIndex] = fixedLength;
            stmt.lastBoundDataLengths[bindPosition] = fixedLength;
        }
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)fixedLength;
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, double val, byte[] b2, int offset) throws SQLException {
        int fixedLength = 8;
        if (val == 0.0) {
            val = 0.0;
        } else if (val != val) {
            val = Double.NaN;
        }
        long longBits = Double.doubleToLongBits(val);
        int lowInt = (int)longBits;
        int highInt = (int)(longBits >> 32);
        int b7 = lowInt;
        int b6 = lowInt >>= 8;
        int b5 = lowInt >>= 8;
        int b4 = lowInt >>= 8;
        int b3 = highInt;
        int b22 = highInt >>= 8;
        int b1 = highInt >>= 8;
        int b0 = highInt >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b22 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
            b4 ^= 0xFFFFFFFF;
            b5 ^= 0xFFFFFFFF;
            b6 ^= 0xFFFFFFFF;
            b7 ^= 0xFFFFFFFF;
        }
        b2[offset + 7] = (byte)b7;
        b2[offset + 6] = (byte)b6;
        b2[offset + 5] = (byte)b5;
        b2[offset + 4] = (byte)b4;
        b2[offset + 3] = (byte)b3;
        b2[offset + 2] = (byte)b22;
        b2[offset + 1] = (byte)b1;
        b2[offset] = (byte)b0;
        return fixedLength;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b2 = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b2, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b2, len), internalType, null, 0);
    }

    static {
        try {
            $$$methodRef$$$5 = BinaryDoubleBinder.class.getDeclaredConstructor(Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BinaryDoubleBinder.class.getDeclaredMethod("getDatum", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BinaryDoubleBinder.class.getDeclaredMethod("getDatumBytes", OraclePreparedStatement.class, Double.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BinaryDoubleBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BinaryDoubleBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BinaryDoubleBinder.class.getDeclaredMethod("init", Binder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

