/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptData;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPluginSpi;
import org.firebirdsql.gds.ng.wire.crypt.KnownServerKey;
import org.firebirdsql.gds.ng.wire.version11.V11WireOperations;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.ExceptionHelper;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class V13WireOperations
extends V11WireOperations {
    private static final Logger log = LoggerFactory.getLogger(V13WireOperations.class);
    private static final String ARC4_PLUGIN_SPI_CLASS_NAME = "org.firebirdsql.gds.ng.wire.crypt.arc4.Arc4EncryptionPluginSpi";
    public static final String CHA_CHA_PLUGIN_SPI_CLASS_NAME = "org.firebirdsql.gds.ng.wire.crypt.chacha.ChaChaEncryptionPluginSpi";
    private static final Map<EncryptionIdentifier, EncryptionPluginSpi> SUPPORTED_ENCRYPTION_PLUGINS;

    public V13WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    public void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket, DbCryptCallback dbCryptCallback, FbWireOperations.ProcessAttachCallback processAttachCallback) throws SQLException, IOException {
        assert (acceptPacket == null || acceptPacket.operation == 98) : "Unexpected operation in AcceptPacket";
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        ClientAuthBlock clientAuthBlock = this.getClientAuthBlock();
        Encoding encoding = this.getEncoding();
        boolean debug = log.isDebugEnabled();
        block7: while (true) {
            String pluginName;
            byte[] data;
            if (acceptPacket != null) {
                data = acceptPacket.p_acpt_data;
                pluginName = acceptPacket.p_acpt_plugin;
                this.addServerKeys(acceptPacket.p_acpt_keys);
                if (debug) {
                    log.debugf("authReceiveResponse: cond_accept data=%d pluginName=%d '%s'", (Object)data.length, (Object)(pluginName != null ? Integer.valueOf(pluginName.length()) : null), (Object)pluginName);
                }
                acceptPacket = null;
            } else {
                int operation = this.readNextOperation();
                switch (operation) {
                    case 90: {
                        xdrIn.readBuffer();
                        throw new FbExceptionBuilder().nonTransientConnectionException(337248272).toSQLException();
                    }
                    case 92: {
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(encoding);
                        xdrIn.readBuffer();
                        this.addServerKeys(xdrIn.readBuffer());
                        if (!debug) break;
                        log.debugf("authReceiveResponse: cont_auth data=%d pluginName=%d '%s'", (Object)data.length, (Object)pluginName.length(), (Object)pluginName);
                        break;
                    }
                    case 97: {
                        log.debugf("Handling db crypt callback using plugin %s", (Object)dbCryptCallback.getDbCryptCallbackName());
                        this.handleCryptKeyCallback(dbCryptCallback);
                        continue block7;
                    }
                    case 98: {
                        xdrIn.readInt();
                        xdrIn.readInt();
                        xdrIn.readInt();
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(encoding);
                        xdrIn.readInt();
                        this.addServerKeys(xdrIn.readBuffer());
                        if (!debug) break;
                        log.debugf("authReceiveResponse: cond_accept data=%d pluginName=%d '%s'", (Object)data.length, (Object)pluginName.length(), (Object)pluginName);
                        break;
                    }
                    case 9: {
                        GenericResponse response = (GenericResponse)this.readOperationResponse(operation, null);
                        boolean wasAuthComplete = clientAuthBlock.isAuthComplete();
                        clientAuthBlock.setAuthComplete(true);
                        processAttachCallback.processAttachResponse(response);
                        this.addServerKeys(response.getData());
                        WireCrypt wireCrypt = this.getAttachProperties().getWireCryptAsEnum();
                        if (!wasAuthComplete && wireCrypt != WireCrypt.DISABLED) {
                            this.tryKnownServerKeys();
                        }
                        return;
                    }
                    default: {
                        throw new SQLException(String.format("Unsupported operation code: %d", operation));
                    }
                }
            }
            if (pluginName != null && pluginName.length() > 0 && Objects.equals(pluginName, clientAuthBlock.getCurrentPluginName())) {
                pluginName = null;
            }
            if (pluginName != null && pluginName.length() > 0 && !clientAuthBlock.switchPlugin(pluginName) || !clientAuthBlock.hasPlugin()) break;
            clientAuthBlock.setServerData(data);
            log.debugf("receiveResponse: authenticate(%s)", (Object)clientAuthBlock.getCurrentPluginName());
            clientAuthBlock.authenticate();
            xdrOut.writeInt(92);
            xdrOut.writeBuffer(clientAuthBlock.getClientData());
            xdrOut.writeString(clientAuthBlock.getCurrentPluginName(), encoding);
            if (clientAuthBlock.isFirstTime()) {
                xdrOut.writeString(clientAuthBlock.getPluginNames(), encoding);
                clientAuthBlock.setFirstTime(false);
            } else {
                xdrOut.writeBuffer(null);
            }
            xdrOut.writeBuffer(null);
            xdrOut.flush();
        }
        throw new FbExceptionBuilder().exception(335544472).toSQLException();
    }

    private CryptSessionConfig getCryptSessionConfig(EncryptionIdentifier encryptionIdentifier, byte[] specificData) throws SQLException {
        ClientAuthBlock clientAuthBlock = this.getClientAuthBlock();
        if (!clientAuthBlock.supportsEncryption() || !encryptionIdentifier.isTypeSymmetric()) {
            throw new FbExceptionBuilder().nonTransientException(337248280).messageParameter(encryptionIdentifier.toString()).toSQLException();
        }
        return CryptSessionConfig.symmetric(encryptionIdentifier, clientAuthBlock.getSessionKey(), specificData);
    }

    private void tryKnownServerKeys() throws IOException, SQLException {
        boolean initializedEncryption = false;
        SQLExceptionChainBuilder<SQLException> chainBuilder = new SQLExceptionChainBuilder<SQLException>();
        for (KnownServerKey.PluginSpecificData pluginSpecificData : this.getPluginSpecificData()) {
            EncryptionIdentifier encryptionIdentifier = pluginSpecificData.getEncryptionIdentifier();
            EncryptionPluginSpi currentEncryptionSpi = SUPPORTED_ENCRYPTION_PLUGINS.get(encryptionIdentifier);
            if (currentEncryptionSpi == null) continue;
            try {
                CryptSessionConfig cryptSessionConfig = this.getCryptSessionConfig(encryptionIdentifier, pluginSpecificData.getSpecificData());
                Throwable throwable = null;
                try {
                    EncryptionPlugin encryptionPlugin = currentEncryptionSpi.createEncryptionPlugin(cryptSessionConfig);
                    EncryptionInitInfo encryptionInitInfo = encryptionPlugin.initializeEncryption();
                    if (encryptionInitInfo.isSuccess()) {
                        this.enableEncryption(encryptionInitInfo);
                        this.clearServerKeys();
                        initializedEncryption = true;
                        log.debugf("Wire encryption established with %s", (Object)encryptionIdentifier);
                        break;
                    }
                    chainBuilder.append(encryptionInitInfo.getException());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cryptSessionConfig == null) continue;
                    if (throwable != null) {
                        try {
                            cryptSessionConfig.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    cryptSessionConfig.close();
                }
            }
            catch (SQLException e) {
                chainBuilder.append(e);
            }
        }
        if (!initializedEncryption && this.getAttachProperties().getWireCryptAsEnum() == WireCrypt.REQUIRED) {
            FbExceptionBuilder exceptionBuilder = new FbExceptionBuilder().nonTransientException(335545064);
            if (chainBuilder.hasException()) {
                exceptionBuilder.cause((Throwable)chainBuilder.getException());
            }
            throw exceptionBuilder.toSQLException();
        }
        if (chainBuilder.hasException()) {
            Object current = chainBuilder.getException();
            if (log.isWarnEnabled()) {
                log.warn(initializedEncryption ? "Wire encryption established, but some plugins failed; see other loglines for details" : "No wire encryption established because of errors");
                log.warnf("Encryption plugin failed; see debug level for stacktraces:\n%s", (Object)ExceptionHelper.collectAllMessages(current));
            }
            if (log.isDebugEnabled()) {
                do {
                    log.debug("Encryption plugin failed", (Throwable)current);
                } while ((current = ((SQLException)current).getNextException()) != null);
            }
        }
    }

    protected void enableEncryption(EncryptionInitInfo encryptionInitInfo) throws SQLException, IOException {
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        Encoding encoding = this.getEncoding();
        EncryptionIdentifier encryptionIdentifier = encryptionInitInfo.getEncryptionIdentifier();
        xdrOut.writeInt(96);
        xdrOut.writeString(encryptionIdentifier.getPluginName(), encoding);
        xdrOut.writeString(encryptionIdentifier.getType(), encoding);
        xdrOut.flush();
        xdrIn.setCipher(encryptionInitInfo.getDecryptionCipher());
        xdrOut.setCipher(encryptionInitInfo.getEncryptionCipher());
        this.readResponse(null);
    }

    @Override
    public final void handleCryptKeyCallback(DbCryptCallback dbCryptCallback) throws IOException, SQLException {
        DbCryptData clientPluginResponse;
        DbCryptData serverPluginData = this.readCryptKeyCallback();
        try {
            clientPluginResponse = dbCryptCallback.handleCallback(serverPluginData);
        }
        catch (Exception e) {
            log.error("Error during database encryption callback, using default empty response", e);
            clientPluginResponse = DbCryptData.EMPTY_DATA;
        }
        this.writeCryptKeyCallback(clientPluginResponse);
    }

    protected DbCryptData readCryptKeyCallback() throws IOException, SQLException {
        XdrInputStream xdrIn = this.getXdrIn();
        byte[] pluginData = xdrIn.readBuffer();
        try {
            return new DbCryptData(pluginData, Integer.MIN_VALUE);
        }
        catch (RuntimeException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248285).cause(e).toSQLException();
        }
    }

    protected void writeCryptKeyCallback(DbCryptData clientPluginResponse) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(97);
        xdrOut.writeBuffer(clientPluginResponse.getPluginData());
        xdrOut.flush();
    }

    static {
        HashMap<EncryptionIdentifier, EncryptionPluginSpi> tempMap = new HashMap<EncryptionIdentifier, EncryptionPluginSpi>();
        for (String spiName : Arrays.asList(ARC4_PLUGIN_SPI_CLASS_NAME, CHA_CHA_PLUGIN_SPI_CLASS_NAME)) {
            try {
                Class<?> spiClass = Class.forName(spiName);
                EncryptionPluginSpi encryptionPluginSpi = (EncryptionPluginSpi)spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tempMap.put(encryptionPluginSpi.getEncryptionIdentifier(), encryptionPluginSpi);
            }
            catch (Exception e) {
                if (!spiName.equals(CHA_CHA_PLUGIN_SPI_CLASS_NAME) || !(e instanceof ClassNotFoundException)) {
                    log.infof("Could not load EncryptionPluginSpi: %s; see debug for details", (Object)spiName);
                }
                log.debugfe("Could not load EncryptionPluginSpi: %s", spiName, e);
            }
        }
        SUPPORTED_ENCRYPTION_PLUGINS = tempMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tempMap);
    }
}

