/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.strings.TruffleString;

public interface FrameInfo {
    public PRootNode getRootNode();

    public int getFirstLineNumber();

    public Object getYieldFrom(Frame var1, int var2, int var3);

    public boolean includeInTraceback();

    public CodeUnit getCodeUnit();

    @Idempotent
    default public int getVariableCount() {
        CodeUnit code = this.getCodeUnit();
        return code.varnames.length + code.cellvars.length + code.freevars.length;
    }

    default public int getRegularVariableCount() {
        return this.getCodeUnit().varnames.length;
    }

    default public TruffleString getVariableName(int slot) {
        CodeUnit code = this.getCodeUnit();
        if (slot < code.varnames.length) {
            return code.varnames[slot];
        }
        if (slot < code.varnames.length + code.cellvars.length) {
            return code.cellvars[slot - code.varnames.length];
        }
        return code.freevars[slot - code.varnames.length - code.cellvars.length];
    }
}

