/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotByteSequenceFactory;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.io.ByteSequence;

final class PolyglotByteSequence
implements ByteSequence,
PolyglotWrapper {
    static final int UNKNOWN_SEQUENCE_LENGTH = -1;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    final Object guestObject;
    private final int start;
    private final int length;
    final PolyglotLanguageContext languageContext;
    final Cache cache;
    final Context contextAnchor;

    PolyglotByteSequence(Object buffer, PolyglotLanguageContext languageContext) {
        this(buffer, languageContext, 0, -1);
    }

    PolyglotByteSequence(Object buffer, PolyglotLanguageContext languageContext, int start, int length) {
        this.guestObject = buffer;
        this.start = start;
        this.length = length;
        this.languageContext = languageContext;
        this.cache = Cache.lookup(languageContext, buffer.getClass());
        this.contextAnchor = languageContext.context.getContextAPI();
    }

    @CompilerDirectives.TruffleBoundary
    public static PolyglotByteSequence create(PolyglotLanguageContext languageContext, Object buffer) {
        return new PolyglotByteSequence(buffer, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    public static PolyglotByteSequence create(PolyglotLanguageContext languageContext, Object buffer, int st, int len) {
        return new PolyglotByteSequence(buffer, languageContext, st, len);
    }

    public String toString() {
        return PolyglotWrapper.toString(this);
    }

    public int hashCode() {
        return PolyglotWrapper.hashCode(this.languageContext, this.guestObject);
    }

    public boolean equals(Object o) {
        if (o instanceof PolyglotByteSequence) {
            return PolyglotWrapper.equals(this.languageContext, this.guestObject, ((PolyglotByteSequence)o).guestObject);
        }
        return false;
    }

    public int length() {
        return (Integer)this.cache.length.call(null, this.languageContext, this.guestObject, this.start, this.length);
    }

    public byte byteAt(int index) {
        return (Byte)this.cache.byteAt.call(null, this.languageContext, this.guestObject, this.start, this.length, index);
    }

    public byte[] toByteArray() {
        return (byte[])this.cache.toByteArray.call(null, this.languageContext, this.guestObject, this.start, this.length);
    }

    public ByteSequence subSequence(int startIndex, int endIndex) {
        return (ByteSequence)this.cache.subSequence.call(null, this.languageContext, this.guestObject, this.start, this.length, startIndex, endIndex);
    }

    @Override
    public Object getGuestObject() {
        return this.guestObject;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    static final class Cache {
        final PolyglotLanguageInstance languageInstance;
        final Class<?> receiverClass;
        final CallTarget byteAt;
        final CallTarget toByteArray;
        final CallTarget subSequence;
        final CallTarget length;

        Cache(PolyglotLanguageInstance languageInstance, Class<?> receiverClass) {
            this.languageInstance = languageInstance;
            this.receiverClass = receiverClass;
            this.byteAt = PolyglotByteSequenceFactory.CacheFactory.ByteAtNodeGen.create(this).getCallTarget();
            this.toByteArray = PolyglotByteSequenceFactory.CacheFactory.ToByteArrayNodeGen.create(this).getCallTarget();
            this.subSequence = PolyglotByteSequenceFactory.CacheFactory.SubSequenceNodeGen.create(this).getCallTarget();
            this.length = PolyglotByteSequenceFactory.CacheFactory.LengthNodeGen.create(this).getCallTarget();
        }

        static Cache lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass) {
            Cache cache = HostToGuestRootNode.lookupHostCodeCache(languageContext, receiverClass, Cache.class);
            if (cache == null) {
                cache = HostToGuestRootNode.installHostCodeCache(languageContext, receiverClass, new Cache(languageContext.getLanguageInstance(), receiverClass), Cache.class);
            }
            assert (cache.receiverClass == receiverClass);
            return cache;
        }

        static abstract class ByteAtNode
        extends PolyglotByteSequenceNode {
            ByteAtNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            static Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached InlinedBranchProfile error) {
                Object start = args[2];
                assert (start instanceof Integer);
                Object length = args[3];
                assert (length instanceof Integer);
                Object key = args[4];
                assert (key instanceof Integer);
                long startOffset = ((Integer)start).intValue();
                int intLength = (Integer)length;
                int offset = (Integer)key;
                if (intLength != -1 && offset + 1 > intLength) {
                    error.enter(node);
                    throw PolyglotInteropErrors.invalidBufferOffset(languageContext, receiver, offset, 1L);
                }
                try {
                    return interop.readBufferByte(receiver, startOffset + (long)offset);
                }
                catch (InvalidBufferOffsetException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.invalidBufferOffset(languageContext, receiver, e.getByteOffset() - startOffset, e.getLength());
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "byteAt()");
                }
            }

            @Override
            protected String getOperationName() {
                return "byteAt";
            }
        }

        static abstract class ToByteArrayNode
        extends PolyglotByteSequenceNode {
            ToByteArrayNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            static Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached InlinedBranchProfile error) {
                long size;
                Object start = args[2];
                assert (start instanceof Integer);
                Object length = args[3];
                assert (length instanceof Integer);
                long startOffset = ((Integer)start).intValue();
                int intLength = (Integer)length;
                if (intLength == -1) {
                    try {
                        size = interop.getBufferSize(receiver);
                    }
                    catch (UnsupportedMessageException e) {
                        error.enter(node);
                        throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "toByteArray()");
                    }
                } else {
                    size = intLength;
                }
                if (size > 0x7FFFFFF7L) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "toByteArray()", "The buffer size %d is greater than the maximum array size %d", size, 0x7FFFFFF7);
                }
                int intSize = (int)size;
                byte[] outArray = new byte[intSize];
                try {
                    interop.readBuffer(receiver, startOffset, outArray, 0, intSize);
                    return outArray;
                }
                catch (InvalidBufferOffsetException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.invalidBufferOffset(languageContext, receiver, e.getByteOffset() - startOffset, e.getLength());
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "toByteArray()");
                }
            }

            @Override
            protected String getOperationName() {
                return "toByteArray";
            }
        }

        static abstract class SubSequenceNode
        extends PolyglotByteSequenceNode {
            SubSequenceNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            static Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached InlinedBranchProfile error) {
                long size;
                Object start = args[2];
                assert (start instanceof Integer);
                Object length = args[3];
                assert (length instanceof Integer);
                Object startIndex = args[4];
                assert (startIndex instanceof Integer);
                Object endIndex = args[5];
                assert (endIndex instanceof Integer);
                int startOffset = (Integer)start;
                int intLength = (Integer)length;
                int intStartIndex = (Integer)startIndex;
                int intEndIndex = (Integer)endIndex;
                if (intLength == -1) {
                    try {
                        size = interop.getBufferSize(receiver);
                    }
                    catch (UnsupportedMessageException e) {
                        error.enter(node);
                        throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "subSequence()");
                    }
                } else {
                    size = intLength;
                }
                int resultLength = intEndIndex - intStartIndex;
                if (intStartIndex < 0 || intEndIndex < intStartIndex || (long)intEndIndex > size) {
                    error.enter(node);
                    throw PolyglotInteropErrors.invalidBufferOffset(languageContext, receiver, intStartIndex, resultLength);
                }
                return PolyglotByteSequence.create(languageContext, receiver, startOffset + intStartIndex, resultLength);
            }

            @Override
            protected String getOperationName() {
                return "subSequence";
            }
        }

        static abstract class LengthNode
        extends PolyglotByteSequenceNode {
            LengthNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            static Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached InlinedBranchProfile error) {
                Object length = args[3];
                assert (length instanceof Integer);
                int intLength = (Integer)length;
                if (intLength == -1) {
                    long size;
                    try {
                        size = interop.getBufferSize(receiver);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                    assert (size >= 0L);
                    assert (size <= Integer.MAX_VALUE);
                    return (int)size;
                }
                return intLength;
            }

            @Override
            protected String getOperationName() {
                return "size";
            }
        }

        static abstract class PolyglotByteSequenceNode
        extends HostToGuestRootNode {
            static final int LIMIT = 5;
            final Cache cache;

            PolyglotByteSequenceNode(Cache cache) {
                super(cache.languageInstance);
                this.cache = cache;
            }

            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String getName() {
                return "PolyglotByteSequence<" + String.valueOf(this.cache.receiverClass) + ">." + this.getOperationName();
            }

            protected abstract String getOperationName();
        }
    }
}

