/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorageEntry;
import org.apache.hc.core5.annotation.Internal;

@Internal
public final class InternalCacheStorage {
    private final Map<String, HttpCacheEntry> map;
    private final Queue<HttpCacheStorageEntry> evictionQueue;
    private final Consumer<HttpCacheStorageEntry> evictionCallback;

    public InternalCacheStorage(final int maxEntries, final Consumer<HttpCacheStorageEntry> evictionCallback) {
        this.evictionCallback = evictionCallback;
        this.map = new LinkedHashMap<String, HttpCacheEntry>(20, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, HttpCacheEntry> eldest) {
                if (this.size() > maxEntries) {
                    if (evictionCallback != null) {
                        InternalCacheStorage.this.evictionQueue.add(new HttpCacheStorageEntry(eldest.getKey(), eldest.getValue()));
                    }
                    return true;
                }
                return false;
            }
        };
        this.evictionQueue = new LinkedList<HttpCacheStorageEntry>();
    }

    public InternalCacheStorage(int maxEntries) {
        this(maxEntries, null);
    }

    public InternalCacheStorage() {
        this(Integer.MAX_VALUE, null);
    }

    public void put(String key, HttpCacheEntry entry) {
        HttpCacheStorageEntry evicted;
        this.map.put(key, entry);
        while ((evicted = this.evictionQueue.poll()) != null) {
            if (this.evictionCallback == null) continue;
            this.evictionCallback.accept(evicted);
        }
    }

    public HttpCacheEntry get(String key) {
        return this.map.get(key);
    }

    public HttpCacheEntry remove(String key) {
        return this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }
}

