/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.ensemble;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXRef;

public interface EnsembleCombiner<T extends Output<T>>
extends Configurable,
Provenancable<ConfiguredObjectProvenance>,
Serializable {
    public Prediction<T> combine(ImmutableOutputInfo<T> var1, List<Prediction<T>> var2);

    public Prediction<T> combine(ImmutableOutputInfo<T> var1, List<Prediction<T>> var2, float[] var3);

    default public ONNXNode exportCombiner(ONNXNode input) {
        Logger.getLogger(this.getClass().getName()).severe("Tried to export an ensemble combiner to ONNX format, but this is not implemented.");
        throw new IllegalStateException("This ensemble cannot be exported as the combiner '" + this.getClass() + "' uses the default implementation of EnsembleCombiner.exportCombiner.");
    }

    default public <U extends ONNXRef<?>> ONNXNode exportCombiner(ONNXNode input, U weight) {
        Logger.getLogger(this.getClass().getName()).severe("Tried to export an ensemble combiner to ONNX format, but this is not implemented.");
        throw new IllegalStateException("This ensemble cannot be exported as the combiner '" + this.getClass() + "' uses the default implementation of EnsembleCombiner.exportCombiner.");
    }
}

