/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointServiceConfigurationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationResponse> {
    private static final SdkField<ServiceConfiguration> SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceConfiguration").getter(CreateVpcEndpointServiceConfigurationResponse.getter(CreateVpcEndpointServiceConfigurationResponse::serviceConfiguration)).setter(CreateVpcEndpointServiceConfigurationResponse.setter(Builder::serviceConfiguration)).constructor(ServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceConfiguration").unmarshallLocationName("serviceConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVpcEndpointServiceConfigurationResponse.getter(CreateVpcEndpointServiceConfigurationResponse::clientToken)).setter(CreateVpcEndpointServiceConfigurationResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVpcEndpointServiceConfigurationResponse.memberNameToFieldInitializer();
    private final ServiceConfiguration serviceConfiguration;
    private final String clientToken;

    private CreateVpcEndpointServiceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serviceConfiguration = builder.serviceConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final ServiceConfiguration serviceConfiguration() {
        return this.serviceConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationResponse)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationResponse other = (CreateVpcEndpointServiceConfigurationResponse)((Object)obj);
        return Objects.equals(this.serviceConfiguration(), other.serviceConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcEndpointServiceConfigurationResponse").add("ServiceConfiguration", (Object)this.serviceConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceConfiguration", SERVICE_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointServiceConfigurationResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointServiceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private ServiceConfiguration serviceConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointServiceConfigurationResponse model) {
            super(model);
            this.serviceConfiguration(model.serviceConfiguration);
            this.clientToken(model.clientToken);
        }

        public final ServiceConfiguration.Builder getServiceConfiguration() {
            return this.serviceConfiguration != null ? this.serviceConfiguration.toBuilder() : null;
        }

        public final void setServiceConfiguration(ServiceConfiguration.BuilderImpl serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration != null ? serviceConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConfiguration(ServiceConfiguration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateVpcEndpointServiceConfigurationResponse build() {
            return new CreateVpcEndpointServiceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationResponse> {
        public Builder serviceConfiguration(ServiceConfiguration var1);

        default public Builder serviceConfiguration(Consumer<ServiceConfiguration.Builder> serviceConfiguration) {
            return this.serviceConfiguration((ServiceConfiguration)((ServiceConfiguration.Builder)ServiceConfiguration.builder().applyMutation(serviceConfiguration)).build());
        }

        public Builder clientToken(String var1);
    }
}

