/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.util.Map;
import java.util.Set;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rule.RuleQueryMapper;
import org.opensearch.rule.action.GetRuleRequest;
import org.opensearch.rule.autotagging.Attribute;

@ExperimentalApi
public class IndexBasedRuleQueryMapper
implements RuleQueryMapper<QueryBuilder> {
    @Override
    public QueryBuilder from(GetRuleRequest request) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        Map<Attribute, Set<String>> attributeFilters = request.getAttributeFilters();
        String id = request.getId();
        boolQuery.filter((QueryBuilder)QueryBuilders.existsQuery((String)request.getFeatureType().getName()));
        if (id != null) {
            return boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)id));
        }
        for (Map.Entry<Attribute, Set<String>> entry : attributeFilters.entrySet()) {
            Attribute attribute = entry.getKey();
            Set<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            BoolQueryBuilder attributeQuery = QueryBuilders.boolQuery();
            for (String value : values) {
                attributeQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)attribute.getName(), (Object)value));
            }
            boolQuery.must((QueryBuilder)attributeQuery);
        }
        return boolQuery;
    }

    @Override
    public QueryBuilder getCardinalityQuery() {
        return QueryBuilders.matchAllQuery();
    }
}

