/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class DefaultStyleDeclarationErrorHandler
implements StyleDeclarationErrorHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> malformedURIs = null;
    private LinkedHashMap<String, String> seShorthands = null;
    private List<String> unassigned = null;
    private List<String> wrongCount = null;
    private List<String> missingReq = null;
    private List<Node> noContainer = null;
    private Map<String, String> unknownIdent = null;
    private Map<String, String> wrongValue = null;
    private LinkedList<String> valueWarnings = null;
    private Map<String, String> unassignedValue = null;
    private List<CSSParseException> sacWarnings = null;
    private List<CSSParseException> sacErrors = null;

    @Override
    public void malformedURIValue(String string) {
        if (this.malformedURIs == null) {
            this.malformedURIs = new LinkedList<String>();
        }
        this.malformedURIs.add(string);
    }

    @Override
    public void shorthandError(String string, String string2) {
        if (this.seShorthands == null) {
            this.seShorthands = new LinkedHashMap();
        }
        this.seShorthands.put(string, string2);
    }

    @Override
    public void shorthandSyntaxError(String string, String string2) {
        this.shorthandError(string, string2);
    }

    @Override
    public void shorthandWarning(String string, String string2) {
        this.shorthandError(string, "Unsafe shorthand value: " + string2);
    }

    @Override
    public void unassignedShorthandValues(String string, String[] stringArray, LexicalUnit[] lexicalUnitArray) {
        if (this.unassigned == null) {
            this.unassigned = new LinkedList<String>();
        }
        for (LexicalUnit lexicalUnit : lexicalUnitArray) {
            this.unassigned.add(lexicalUnit.toString());
        }
    }

    @Override
    public void wrongSubpropertyCount(String string, int n) {
        if (this.wrongCount == null) {
            this.wrongCount = new LinkedList<String>();
        }
        this.wrongCount.add(string);
    }

    @Override
    public void unknownIdentifier(String string, String string2) {
        if (this.unknownIdent == null) {
            this.unknownIdent = new HashMap<String, String>();
        }
        this.unknownIdent.put(string, string2);
    }

    @Override
    public void missingRequiredProperty(String string) {
        if (this.missingReq == null) {
            this.missingReq = new LinkedList<String>();
        }
        this.missingReq.add(string);
    }

    @Override
    public void wrongValue(String string, CSSPropertyValueException cSSPropertyValueException) {
        if (this.wrongValue == null) {
            this.wrongValue = new HashMap<String, String>();
        }
        this.wrongValue.put(string, cSSPropertyValueException.getValueText());
    }

    @Override
    public void syntaxWarning(String string) {
        if (this.valueWarnings == null) {
            this.valueWarnings = new LinkedList();
        }
        this.valueWarnings.add(string);
    }

    @Override
    public void compatWarning(String string, String string2) {
        this.syntaxWarning("IE compat value in property " + string + ": " + string2);
    }

    @Override
    public void noContainingBlock(String string, Node node) {
        if (this.noContainer == null) {
            this.noContainer = new LinkedList<Node>();
        }
        this.noContainer.add(node);
    }

    @Override
    public void unassignedShorthandValue(String string, String string2) {
        if (this.unassignedValue == null) {
            this.unassignedValue = new HashMap<String, String>();
        }
        this.unassignedValue.put(string, string2);
    }

    @Override
    public boolean hasErrors() {
        return this.malformedURIs != null || this.seShorthands != null || this.wrongCount != null || this.missingReq != null || this.unknownIdent != null || this.wrongValue != null || this.unassignedValue != null || this.sacErrors != null;
    }

    @Override
    public boolean hasWarnings() {
        return this.sacWarnings != null || this.valueWarnings != null;
    }

    public List<String> getMalformedURIs() {
        return this.malformedURIs;
    }

    public Map<String, String> getShorthandsWithErrors() {
        return this.seShorthands;
    }

    public List<String> getUnassignedSubproperties() {
        return this.unassigned;
    }

    public List<String> getWrongSubpropertyCount() {
        return this.wrongCount;
    }

    public List<String> getMissingRequiredValues() {
        return this.missingReq;
    }

    public Map<String, String> getUnknownIdentifiers() {
        return this.unknownIdent;
    }

    public Map<String, String> getWrongValues() {
        return this.wrongValue;
    }

    public List<Node> getNoContainingBlock() {
        return this.noContainer;
    }

    public Map<String, String> getUnassignedValues() {
        return this.unassignedValue;
    }

    public LinkedList<String> getSyntaxWarnings() {
        return this.valueWarnings;
    }

    @Override
    public void reset() {
        this.malformedURIs = null;
        this.seShorthands = null;
        this.unassigned = null;
        this.wrongCount = null;
        this.missingReq = null;
        this.unknownIdent = null;
        this.wrongValue = null;
        this.noContainer = null;
        this.unassignedValue = null;
        this.sacWarnings = null;
        this.sacErrors = null;
    }

    @Override
    public void sacWarning(CSSParseException cSSParseException, int n) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<CSSParseException>();
        }
        this.sacWarnings.add(cSSParseException);
    }

    @Override
    public void sacError(CSSParseException cSSParseException, int n) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<CSSParseException>();
        }
        this.sacErrors.add(cSSParseException);
    }

    public List<CSSParseException> getSACWarnings() {
        return this.sacWarnings;
    }

    public List<CSSParseException> getSACErrors() {
        return this.sacErrors;
    }

    public void errorSummary(StringBuilder stringBuilder) {
        Iterator<Object> iterator;
        if (this.malformedURIs != null && !this.malformedURIs.isEmpty()) {
            stringBuilder.append("Malformed URIs:");
            iterator = this.malformedURIs.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append((String)iterator.next());
            }
            stringBuilder.append('\n');
        }
        if (this.seShorthands != null && !this.seShorthands.isEmpty()) {
            stringBuilder.append("Shorthands with syntax error:");
            for (Map.Entry entry : this.seShorthands.entrySet()) {
                stringBuilder.append(' ').append((String)entry.getKey()).append(" (").append((String)entry.getValue()).append(')');
            }
            stringBuilder.append('\n');
        }
        if (this.wrongCount != null && !this.wrongCount.isEmpty()) {
            stringBuilder.append("Wrong subproperty count:");
            iterator = this.wrongCount.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append((String)iterator.next());
            }
            stringBuilder.append('\n');
        }
        if (this.missingReq != null && !this.missingReq.isEmpty()) {
            stringBuilder.append("Missing required value(s) for property:");
            iterator = this.missingReq.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append((String)iterator.next());
            }
            stringBuilder.append('\n');
        }
        if (this.unknownIdent != null && !this.unknownIdent.isEmpty()) {
            stringBuilder.append("Unknown identifiers:");
            for (Map.Entry entry : this.unknownIdent.entrySet()) {
                stringBuilder.append(' ').append((String)entry.getKey()).append(':').append(' ').append((String)entry.getValue());
            }
            stringBuilder.append('\n');
        }
        if (this.wrongValue != null && !this.wrongValue.isEmpty()) {
            stringBuilder.append("Wrong values:");
            for (Map.Entry entry : this.wrongValue.entrySet()) {
                stringBuilder.append(' ').append((String)entry.getKey()).append(':').append(' ').append((String)entry.getValue());
            }
            stringBuilder.append('\n');
        }
        if (this.noContainer != null && !this.noContainer.isEmpty()) {
            stringBuilder.append("There were ").append(this.noContainer.size()).append(" nodes without containing block.\n");
        }
        if (this.unassignedValue != null) {
            stringBuilder.append("Shorthands with unassigned values:\n");
            for (Map.Entry entry : this.unassignedValue.entrySet()) {
                stringBuilder.append(' ').append((String)entry.getKey()).append(':').append(' ').append((String)entry.getValue());
            }
            stringBuilder.append('\n');
        }
        if (this.sacErrors != null) {
            stringBuilder.append("There were ").append(this.sacErrors.size()).append(" NSAC errors.\n");
        }
    }

    public void warningSummary(StringBuilder stringBuilder) {
        if (this.sacWarnings != null) {
            stringBuilder.append("There were ").append(this.sacWarnings.size()).append(" NSAC warnings.\n");
        }
        if (this.valueWarnings != null) {
            stringBuilder.append("There were ").append(this.valueWarnings.size()).append(" value warnings:\n");
            Iterator iterator = this.valueWarnings.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append("- ").append((String)iterator.next()).append('\n');
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = null;
        if (this.hasErrors()) {
            stringBuilder = new StringBuilder(256);
            this.errorSummary(stringBuilder);
        }
        if (this.hasWarnings()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(80);
            }
            this.warningSummary(stringBuilder);
        } else if (stringBuilder == null) {
            return "No errors";
        }
        return stringBuilder.toString();
    }
}

