/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.data.hints;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderConfiguration;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderDescriptor;

public abstract class ValueHintContextConfiguration {
    private final transient DBDValueHintContext.HintConfigurationLevel level;
    protected final Map<String, ValueHintProviderConfiguration> configurationMap = new LinkedHashMap<String, ValueHintProviderConfiguration>();

    public ValueHintContextConfiguration(@NotNull DBDValueHintContext.HintConfigurationLevel level) {
        this.level = level;
    }

    public abstract ValueHintContextConfiguration getParent();

    public DBDValueHintContext.HintConfigurationLevel getLevel() {
        return this.level;
    }

    public Map<String, ValueHintProviderConfiguration> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<String, ValueHintProviderConfiguration> configurationMap) {
        this.configurationMap.clear();
        this.configurationMap.putAll(configurationMap);
    }

    @NotNull
    public ValueHintProviderConfiguration getProviderConfiguration(@NotNull ValueHintProviderDescriptor descriptor) {
        ValueHintProviderConfiguration configuration = this.configurationMap.get(descriptor.getId());
        if (configuration == null) {
            configuration = new ValueHintProviderConfiguration(descriptor.getId());
            ValueHintContextConfiguration parent = this.getParent();
            if (parent == null) {
                configuration.setEnabled(descriptor.isVisibleByDefault());
            } else {
                ValueHintProviderConfiguration pConfig = parent.getProviderConfiguration(descriptor);
                configuration.setEnabled(pConfig.isEnabled());
                configuration.setParameters(pConfig.getParameters());
            }
            this.configurationMap.put(descriptor.getId(), configuration);
        }
        return configuration;
    }

    public void setConfiguration(@NotNull ValueHintProviderDescriptor descriptor, @Nullable ValueHintProviderConfiguration configuration) {
        if (configuration == null) {
            this.configurationMap.remove(descriptor.getId());
        } else {
            this.configurationMap.put(descriptor.getId(), configuration);
        }
    }

    public boolean isHintEnabled(ValueHintProviderDescriptor descriptor) {
        return this.getProviderConfiguration(descriptor).isEnabled();
    }

    public abstract void saveConfiguration();

    public abstract void deleteConfiguration();
}

