/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarksHandlerImpl;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmark;

public class DBNBookmarkFolder
extends DBNResource {
    public DBNBookmarkFolder(DBNNode parentNode, IResource resource, DBPResourceHandler handler) throws DBException, CoreException {
        super(parentNode, resource, handler);
    }

    @NotNull
    public DBPImage getResourceNodeIcon() {
        IResource resource = this.getResource();
        if (NavigatorResources.isRootResource((DBPProject)this.getOwnerProject(), (IResource)resource)) {
            return UIIcon.BOOKMARK_FOLDER;
        }
        return super.getResourceNodeIcon();
    }

    public boolean supportsDrop(DBNNode otherNode) {
        if (otherNode instanceof DBNDatabaseNode || otherNode instanceof DBNBookmark) {
            return true;
        }
        return super.supportsDrop(otherNode);
    }

    public void dropNodes(DBRProgressMonitor monitor, Collection<DBNNode> nodes) throws DBException {
        for (DBNNode node : nodes) {
            if (node instanceof DBNDatabaseNode) {
                BookmarksHandlerImpl.createBookmark((DBNDatabaseNode)node, node.getNodeDisplayName(), (IFolder)this.getResource());
                continue;
            }
            if (!(node instanceof DBNBookmark)) continue;
            super.dropNodes(monitor, Collections.singleton(node));
        }
    }

    public boolean supportsPaste(@NotNull DBNNode other) {
        return other instanceof DBNDatabaseNode;
    }

    public void pasteNodes(@NotNull Collection<DBNNode> nodes) throws DBException {
        for (DBNNode node : nodes) {
            if (!(node instanceof DBNDatabaseNode)) continue;
            BookmarksHandlerImpl.createBookmark((DBNDatabaseNode)node, node.getNodeDisplayName(), (IFolder)this.getResource());
        }
    }
}

