from typing import Any, Optional

# AWS Docs: https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html

SSL_POLICIES = {
    "ELBSecurityPolicy-TLS13-1-3-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-3-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
        ],
        "ssl_protocols": ["TLSv1.3"],
    },
    "ELBSecurityPolicy-TLS13-1-3-PQ-2025-09": {
        "name": "ELBSecurityPolicy-TLS13-1-3-PQ-2025-09",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
        ],
        "ssl_protocols": ["TLSv1.3"],
    },
    "ELBSecurityPolicy-TLS13-1-2-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-2-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-PQ-2025-09": {
        "name": "ELBSecurityPolicy-TLS13-1-2-PQ-2025-09",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-Res-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-2-Res-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-Res-PQ-2025-09": {
        "name": "ELBSecurityPolicy-TLS13-1-2-Res-PQ-2025-09",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-Ext2-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-2-Ext2-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-Ext2-PQ-2025-09": {
        "name": "ELBSecurityPolicy-TLS13-1-2-Ext2-PQ-2025-09",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-Ext1-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-2-Ext1-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-2-Ext1-PQ-2025-09": {
        "name": "ELBSecurityPolicy-TLS13-1-2-Ext1-PQ-2025-09",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS13-1-1-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-1-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2", "TLSv1.1"],
    },
    "ELBSecurityPolicy-TLS13-1-0-2021-06": {
        "name": "ELBSecurityPolicy-TLS13-1-0-2021-06",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"],
    },
    "ELBSecurityPolicy-TLS13-1-0-PQ-2025-09": {
        "name": "ELBSecurityPolicy-TLS13-1-0-PQ-2025-09",
        "ciphers": [
            "TLS_AES_128_GCM_SHA256",
            "TLS_AES_256_GCM_SHA384",
            "TLS_CHACHA20_POLY1305_SHA256",
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"],
    },
    "ELBSecurityPolicy-TLS-1-2-Ext-2018-06": {
        "name": "ELBSecurityPolicy-TLS-1-2-Ext-2018-06",
        "ciphers": [
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS-1-2-2017-01": {
        "name": "ELBSecurityPolicy-TLS-1-2-2017-01",
        "ciphers": [
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
        ],
        "ssl_protocols": ["TLSv1.2"],
    },
    "ELBSecurityPolicy-TLS-1-1-2017-01": {
        "name": "ELBSecurityPolicy-TLS-1-1-2017-01",
        "ciphers": [
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.2", "TLSv1.1"],
    },
    "ELBSecurityPolicy-2016-08": {
        "name": "ELBSecurityPolicy-2016-08",
        "ciphers": [
            "ECDHE-ECDSA-AES128-GCM-SHA256",
            "ECDHE-RSA-AES128-GCM-SHA256",
            "ECDHE-ECDSA-AES128-SHA256",
            "ECDHE-RSA-AES128-SHA256",
            "ECDHE-ECDSA-AES128-SHA",
            "ECDHE-RSA-AES128-SHA",
            "ECDHE-ECDSA-AES256-GCM-SHA384",
            "ECDHE-RSA-AES256-GCM-SHA384",
            "ECDHE-ECDSA-AES256-SHA384",
            "ECDHE-RSA-AES256-SHA384",
            "ECDHE-ECDSA-AES256-SHA",
            "ECDHE-RSA-AES256-SHA",
            "AES128-GCM-SHA256",
            "AES128-SHA256",
            "AES128-SHA",
            "AES256-GCM-SHA384",
            "AES256-SHA256",
            "AES256-SHA",
        ],
        "ssl_protocols": ["TLSv1.2", "TLSv1.1", "TLSv1"],
    },
}


def build_policy(name: str, data: dict[str, Any]) -> dict[str, Optional[object]]:
    # Adding priority numbers to ciphers and restructuring output to required format
    ciphers = [
        {"Name": c, "Priority": i + 1} for i, c in enumerate(data.get("ciphers", []))
    ]
    return {
        "Name": name,
        "SslProtocols": data.get("ssl_protocols", []),
        "Ciphers": ciphers,
    }
